/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.AmericanReplaceRule;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleUS;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.SymSpellRule;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;

public class AmericanEnglish
extends English {
    private static final String LANGUAGE_SHORT_CODE = "en-US";
    private static volatile Throwable instantiationTrace;

    public AmericanEnglish() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected AmericanEnglish(boolean fakeValue) {
    }

    @Override
    public String[] getCountries() {
        return new String[]{"US"};
    }

    @Override
    public String getName() {
        return "English (US)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new AmericanReplaceRule(messages, "/en/en-US/replace.txt"));
        rules.add((Rule)new UnitConversionRuleUS(messages));
        return rules;
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikAmericanSpellerRule(messages, (Language)this, null, Collections.emptyList());
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, lm, globalConfig, userConfig, motherTongue, altLanguages));
        if (SuggestionsChanges.isRunningExperiment((String)"SymSpell") || SuggestionsChanges.isRunningExperiment((String)"SymSpell+NewSuggestionsOrderer")) {
            rules.add((Rule)new SymSpellRule(messages, (Language)this, userConfig, altLanguages, lm));
        } else {
            rules.add((Rule)new MorfologikAmericanSpellerRule(messages, (Language)this, globalConfig, userConfig, altLanguages, lm, motherTongue));
        }
        return rules;
    }

    @NotNull
    public static English getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof English) {
            English americanEnglish = (English)language;
            return americanEnglish;
        }
        throw new RuntimeException("AmericanEnglish language expected, got " + String.valueOf(language));
    }
}

