/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.kotlin.sdk.server;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.modelcontextprotocol.kotlin.sdk.server.EndEvent;
import io.modelcontextprotocol.kotlin.sdk.server.FeatureListener;
import io.modelcontextprotocol.kotlin.sdk.server.FeatureNotificationService;
import io.modelcontextprotocol.kotlin.sdk.server.NotificationEvent;
import io.modelcontextprotocol.kotlin.sdk.server.SendEvent;
import io.modelcontextprotocol.kotlin.sdk.server.ServerSession;
import io.modelcontextprotocol.kotlin.sdk.server.SessionNotificationJob;
import io.modelcontextprotocol.kotlin.sdk.types.Notification;
import io.modelcontextprotocol.kotlin.sdk.types.PromptListChangedNotification;
import io.modelcontextprotocol.kotlin.sdk.types.ResourceListChangedNotification;
import io.modelcontextprotocol.kotlin.sdk.types.ResourceUpdatedNotification;
import io.modelcontextprotocol.kotlin.sdk.types.ResourceUpdatedNotificationParams;
import io.modelcontextprotocol.kotlin.sdk.types.ServerNotification;
import io.modelcontextprotocol.kotlin.sdk.types.ToolListChangedNotification;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000e\u001a\u00020\r2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0014J#\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\n\u0010\u0018\u001a\u00060\tj\u0002`\nH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\n\u0010\u0018\u001a\u00060\tj\u0002`\nH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0017\u0010 \u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00102\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u001a\u00106\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b6\u00103\u001a\u0004\b7\u00105R\u001a\u00108\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b8\u00103\u001a\u0004\b9\u00105R\u001a\u0010:\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b:\u00103\u001a\u0004\b;\u00105\u00a8\u0006<"}, d2={"Lio/modelcontextprotocol/kotlin/sdk/server/FeatureNotificationService;", "", "", "notificationBufferCapacity", "Lkotlin/time/Clock;", "clock", "<init>", "(ILkotlin/time/Clock;)V", "Lkotlin/Function1;", "", "Lio/modelcontextprotocol/kotlin/sdk/server/FeatureKey;", "Lio/modelcontextprotocol/kotlin/sdk/types/ServerNotification;", "notificationProvider", "Lio/modelcontextprotocol/kotlin/sdk/server/FeatureListener;", "featureListener", "(Lkotlin/jvm/functions/Function1;)Lio/modelcontextprotocol/kotlin/sdk/server/FeatureListener;", "Lio/modelcontextprotocol/kotlin/sdk/server/ServerSession;", "session", "", "subscribeSession$kotlin_sdk_server", "(Lio/modelcontextprotocol/kotlin/sdk/server/ServerSession;)V", "subscribeSession", "unsubscribeSession$kotlin_sdk_server", "unsubscribeSession", "resourceKey", "subscribeToResourceUpdate$kotlin_sdk_server", "(Lio/modelcontextprotocol/kotlin/sdk/server/ServerSession;Ljava/lang/String;)V", "subscribeToResourceUpdate", "unsubscribeFromResourceUpdate$kotlin_sdk_server", "unsubscribeFromResourceUpdate", "Lio/modelcontextprotocol/kotlin/sdk/types/Notification;", "notification", "emit", "(Lio/modelcontextprotocol/kotlin/sdk/types/Notification;)V", "", "getCurrentTimestamp", "()J", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/time/Clock;", "Lkotlinx/coroutines/CoroutineScope;", "notificationScope", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/modelcontextprotocol/kotlin/sdk/server/NotificationEvent;", "notificationEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "toolListChangedListener", "Lio/modelcontextprotocol/kotlin/sdk/server/FeatureListener;", "getToolListChangedListener$kotlin_sdk_server", "()Lio/modelcontextprotocol/kotlin/sdk/server/FeatureListener;", "promptListChangedListener", "getPromptListChangedListener$kotlin_sdk_server", "resourceListChangedListener", "getResourceListChangedListener$kotlin_sdk_server", "resourceUpdatedListener", "getResourceUpdatedListener$kotlin_sdk_server", "kotlin-sdk-server"})
@SourceDebugExtension(value={"SMAP\nFeatureNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureNotificationService.kt\nio/modelcontextprotocol/kotlin/sdk/server/FeatureNotificationService\n+ 2 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n175#2,4:375\n175#2,4:379\n175#2,4:383\n175#2,4:389\n1869#3,2:387\n*S KotlinDebug\n*F\n+ 1 FeatureNotificationService.kt\nio/modelcontextprotocol/kotlin/sdk/server/FeatureNotificationService\n*L\n260#1:375,4\n289#1:379,4\n340#1:383,4\n344#1:389,4\n369#1:387,2\n*E\n"})
public final class FeatureNotificationService {
    @NotNull
    private final Clock clock;
    @NotNull
    private final CoroutineScope notificationScope;
    @NotNull
    private final MutableSharedFlow<NotificationEvent> notificationEvents;
    @NotNull
    private volatile /* synthetic */ Object emitJobs;
    private static final /* synthetic */ AtomicReferenceFieldUpdater emitJobs$FU;
    @NotNull
    private volatile /* synthetic */ Object sessionNotificationJobs;
    private static final /* synthetic */ AtomicReferenceFieldUpdater sessionNotificationJobs$FU;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FeatureListener toolListChangedListener;
    @NotNull
    private final FeatureListener promptListChangedListener;
    @NotNull
    private final FeatureListener resourceListChangedListener;
    @NotNull
    private final FeatureListener resourceUpdatedListener;

    public FeatureNotificationService(int notificationBufferCapacity, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.notificationScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        this.notificationEvents = SharedFlowKt.MutableSharedFlow$default((int)0, (int)notificationBufferCapacity, (BufferOverflow)BufferOverflow.SUSPEND, (int)1, null);
        this.emitJobs = ExtensionsKt.persistentSetOf();
        this.sessionNotificationJobs = ExtensionsKt.persistentMapOf();
        this.logger = KotlinLogging.INSTANCE.logger(FeatureNotificationService::logger$lambda$0);
        this.toolListChangedListener = this.featureListener((Function1<? super String, ? extends ServerNotification>)((Function1)FeatureNotificationService::toolListChangedListener$lambda$0));
        this.promptListChangedListener = this.featureListener((Function1<? super String, ? extends ServerNotification>)((Function1)FeatureNotificationService::promptListChangedListener$lambda$0));
        this.resourceListChangedListener = this.featureListener((Function1<? super String, ? extends ServerNotification>)((Function1)FeatureNotificationService::resourceListChangedListener$lambda$0));
        this.resourceUpdatedListener = this.featureListener((Function1<? super String, ? extends ServerNotification>)((Function1)FeatureNotificationService::resourceUpdatedListener$lambda$0));
    }

    public /* synthetic */ FeatureNotificationService(int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(n, clock);
    }

    private final FeatureListener featureListener(Function1<? super String, ? extends ServerNotification> notificationProvider) {
        return new FeatureListener(notificationProvider, this){
            final /* synthetic */ Function1<String, ServerNotification> $notificationProvider;
            final /* synthetic */ FeatureNotificationService this$0;
            {
                this.$notificationProvider = $notificationProvider;
                this.this$0 = $receiver;
            }

            public void onFeatureUpdated(String featureKey) {
                Intrinsics.checkNotNullParameter((Object)featureKey, (String)"featureKey");
                ServerNotification notification = (ServerNotification)this.$notificationProvider.invoke((Object)featureKey);
                FeatureNotificationService.access$getLogger$p(this.this$0).debug(() -> featureListener.1.onFeatureUpdated$lambda$0(notification));
                FeatureNotificationService.access$emit(this.this$0, notification);
            }

            private static final Object onFeatureUpdated$lambda$0(ServerNotification $notification) {
                return "Emitting notification: " + $notification.getMethod().getValue();
            }
        };
    }

    @NotNull
    public final FeatureListener getToolListChangedListener$kotlin_sdk_server() {
        return this.toolListChangedListener;
    }

    @NotNull
    public final FeatureListener getPromptListChangedListener$kotlin_sdk_server() {
        return this.promptListChangedListener;
    }

    @NotNull
    public final FeatureListener getResourceListChangedListener$kotlin_sdk_server() {
        return this.resourceListChangedListener;
    }

    @NotNull
    public final FeatureListener getResourceUpdatedListener$kotlin_sdk_server() {
        return this.resourceUpdatedListener;
    }

    public final void subscribeSession$kotlin_sdk_server(@NotNull ServerSession session) {
        PersistentMap persistentMap;
        PersistentMap upd$iv;
        Object cur$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.logger.info(() -> FeatureNotificationService.subscribeSession$lambda$0(session));
        long timestamp = this.getCurrentTimestamp();
        FeatureNotificationService $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            cur$iv = $this$getAndUpdate$iv.sessionNotificationJobs;
            PersistentMap it = (PersistentMap)cur$iv;
            boolean bl = false;
            if (it.containsKey((Object)session.getSessionId())) {
                this.logger.info(() -> FeatureNotificationService.subscribeSession$lambda$1$0(session));
                persistentMap = it;
                continue;
            }
            persistentMap = it.put((Object)session.getSessionId(), (Object)new SessionNotificationJob(session, this.notificationScope, (SharedFlow<? extends NotificationEvent>)((SharedFlow)this.notificationEvents), timestamp));
        } while (!sessionNotificationJobs$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = persistentMap));
        this.logger.info(() -> FeatureNotificationService.subscribeSession$lambda$2(session));
    }

    public final void unsubscribeSession$kotlin_sdk_server(@NotNull ServerSession session) {
        PersistentMap it;
        PersistentMap upd$iv;
        Object cur$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.logger.info(() -> FeatureNotificationService.unsubscribeSession$lambda$0(session));
        FeatureNotificationService $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            cur$iv = $this$getAndUpdate$iv.sessionNotificationJobs;
            it = (PersistentMap)cur$iv;
            boolean bl = false;
            SessionNotificationJob sessionNotificationJob = (SessionNotificationJob)it.get((Object)session.getSessionId());
            if (sessionNotificationJob == null) continue;
            sessionNotificationJob.cancel();
        } while (!sessionNotificationJobs$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = it.remove((Object)session.getSessionId())));
        this.logger.info(() -> FeatureNotificationService.unsubscribeSession$lambda$2(session));
    }

    public final void subscribeToResourceUpdate$kotlin_sdk_server(@NotNull ServerSession session, @NotNull String resourceKey) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)resourceKey, (String)"resourceKey");
        this.logger.info(() -> FeatureNotificationService.subscribeToResourceUpdate$lambda$0(resourceKey, session));
        SessionNotificationJob sessionNotificationJob = (SessionNotificationJob)((PersistentMap)this.sessionNotificationJobs).get((Object)session.getSessionId());
        if (sessionNotificationJob != null) {
            sessionNotificationJob.subscribe(resourceKey, this.getCurrentTimestamp());
        }
        this.logger.info(() -> FeatureNotificationService.subscribeToResourceUpdate$lambda$1(resourceKey, session));
    }

    public final void unsubscribeFromResourceUpdate$kotlin_sdk_server(@NotNull ServerSession session, @NotNull String resourceKey) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)resourceKey, (String)"resourceKey");
        this.logger.info(() -> FeatureNotificationService.unsubscribeFromResourceUpdate$lambda$0(resourceKey, session));
        SessionNotificationJob sessionNotificationJob = (SessionNotificationJob)((PersistentMap)this.sessionNotificationJobs).get((Object)session.getSessionId());
        if (sessionNotificationJob != null) {
            sessionNotificationJob.unsubscribe(resourceKey);
        }
        this.logger.info(() -> FeatureNotificationService.unsubscribeFromResourceUpdate$lambda$1(resourceKey, session));
    }

    private final void emit(Notification notification) {
        PersistentSet it;
        PersistentSet upd$iv;
        Object cur$iv;
        long timestamp = this.getCurrentTimestamp();
        this.logger.info(() -> FeatureNotificationService.emit$lambda$0(timestamp, notification));
        Job job2 = BuildersKt.launch$default((CoroutineScope)this.notificationScope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timestamp, notification, null){
            int label;
            final /* synthetic */ FeatureNotificationService this$0;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                this.$notification = $notification;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FeatureNotificationService.access$getLogger$p(this.this$0).debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(long io.modelcontextprotocol.kotlin.sdk.types.Notification ), ()Ljava/lang/Object;)((long)this.$timestamp, (Notification)this.$notification));
                        this.label = 1;
                        v0 = FeatureNotificationService.access$getNotificationEvents$p(this.this$0).emit((Object)new SendEvent(this.$timestamp, this.$notification), (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        FeatureNotificationService.access$getLogger$p(this.this$0).debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(long io.modelcontextprotocol.kotlin.sdk.types.Notification ), ()Ljava/lang/Object;)((long)this.$timestamp, (Notification)this.$notification));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0(long $timestamp, Notification $notification) {
                return "Actually emitting notification " + $timestamp + ": " + $notification;
            }

            private static final Object invokeSuspend$lambda$1(long $timestamp, Notification $notification) {
                return "Notification emitted " + $timestamp + ": " + $notification;
            }
        }), (int)1, null);
        FeatureNotificationService $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            cur$iv = $this$getAndUpdate$iv.emitJobs;
            it = (PersistentSet)cur$iv;
            boolean bl = false;
        } while (!emitJobs$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = it.add((Object)job2)));
        job2.invokeOnCompletion(arg_0 -> FeatureNotificationService.emit$lambda$2(this, job2, arg_0));
        job2.start();
    }

    private final long getCurrentTimestamp() {
        return this.clock.now().toEpochMilliseconds();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof close.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ FeatureNotificationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.close((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, close$lambda$0(), ()Ljava/lang/Object;)());
                $continuation.label = 1;
                v0 = AwaitKt.joinAll((Collection)((Collection)this.emitJobs), (Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                $continuation.label = 2;
                v1 = BuildersKt.launch$default((CoroutineScope)this.notificationScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ FeatureNotificationService this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                FeatureNotificationService.access$getLogger$p(this.this$0).info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(), ()Ljava/lang/Object;)());
                                this.label = 1;
                                v0 = FeatureNotificationService.access$getNotificationEvents$p(this.this$0).emit((Object)new EndEvent(FeatureNotificationService.access$getCurrentTimestamp(this.this$0)), (Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                FeatureNotificationService.access$getLogger$p(this.this$0).info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(), ()Ljava/lang/Object;)());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Object invokeSuspend$lambda$0() {
                        return "Emitting end event";
                    }

                    private static final Object invokeSuspend$lambda$1() {
                        return "End event emitted";
                    }
                }), (int)3, null).join((Continuation)$continuation);
                if (v1 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl29
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                $this$forEach$iv = ((PersistentMap)this.sessionNotificationJobs).values();
                $i$f$forEach = 0;
                var4_7 = $this$forEach$iv.iterator();
lbl32:
                // 3 sources

                while (var4_7.hasNext()) {
                    element$iv = var4_7.next();
                    it = (SessionNotificationJob)element$iv;
                    $i$a$-forEach-FeatureNotificationService$close$4 = 0;
                    $continuation.L$0 = $this$forEach$iv;
                    $continuation.L$1 = var4_7;
                    $continuation.L$2 = element$iv;
                    $continuation.L$3 = it;
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-FeatureNotificationService$close$4;
                    $continuation.label = 3;
                    v2 = it.join((Continuation<? super Unit>)$continuation);
                    if (v2 != var10_4) continue;
                    return var10_4;
                }
                break;
            }
            case 3: {
                $i$a$-forEach-FeatureNotificationService$close$4 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                it = (SessionNotificationJob)$continuation.L$3;
                element$iv = $continuation.L$2;
                var4_7 = (Iterator)$continuation.L$1;
                $this$forEach$iv = (Iterable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl32
            }
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.notificationScope, null, (int)1, null);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final ServerNotification toolListChangedListener$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ToolListChangedNotification(null, 1, null);
    }

    private static final ServerNotification promptListChangedListener$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PromptListChangedNotification(null, 1, null);
    }

    private static final ServerNotification resourceListChangedListener$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ResourceListChangedNotification(null, 1, null);
    }

    private static final ServerNotification resourceUpdatedListener$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ResourceUpdatedNotification(new ResourceUpdatedNotificationParams(it, null, 2, null));
    }

    private static final Object subscribeSession$lambda$0(ServerSession $session) {
        return "Subscribing session for notifications sessionId: " + $session.getSessionId();
    }

    private static final Object subscribeSession$lambda$1$0(ServerSession $session) {
        return "Session already subscribed: " + $session.getSessionId();
    }

    private static final Object subscribeSession$lambda$2(ServerSession $session) {
        return "Subscribed session for notifications sessionId: " + $session.getSessionId();
    }

    private static final Object unsubscribeSession$lambda$0(ServerSession $session) {
        return "Unsubscribing from list changed notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object unsubscribeSession$lambda$2(ServerSession $session) {
        return "Unsubscribed from list changed notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object subscribeToResourceUpdate$lambda$0(String $resourceKey, ServerSession $session) {
        return "Subscribing to resource " + $resourceKey + " update notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object subscribeToResourceUpdate$lambda$1(String $resourceKey, ServerSession $session) {
        return "Subscribed to resource " + $resourceKey + " update notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object unsubscribeFromResourceUpdate$lambda$0(String $resourceKey, ServerSession $session) {
        return "Unsubscribing from resource " + $resourceKey + " update notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object unsubscribeFromResourceUpdate$lambda$1(String $resourceKey, ServerSession $session) {
        return "Unsubscribed from resource " + $resourceKey + " update notifications for sessionId: " + $session.getSessionId();
    }

    private static final Object emit$lambda$0(long $timestamp, Notification $notification) {
        return "Emitting notification " + $timestamp + ": " + $notification;
    }

    private static final Unit emit$lambda$2(FeatureNotificationService this$0, Job $job, Throwable it) {
        PersistentSet it2;
        PersistentSet upd$iv;
        Object cur$iv;
        FeatureNotificationService $this$getAndUpdate$iv = this$0;
        boolean $i$f$getAndUpdate = false;
        do {
            cur$iv = $this$getAndUpdate$iv.emitJobs;
            it2 = (PersistentSet)cur$iv;
            boolean bl = false;
        } while (!emitJobs$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = it2.remove((Object)$job)));
        return Unit.INSTANCE;
    }

    private static final Object close$lambda$0() {
        return "Closing feature notification service";
    }

    public FeatureNotificationService() {
        this(0, null, 3, null);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(FeatureNotificationService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$emit(FeatureNotificationService $this, Notification notification) {
        $this.emit(notification);
    }

    public static final /* synthetic */ MutableSharedFlow access$getNotificationEvents$p(FeatureNotificationService $this) {
        return $this.notificationEvents;
    }

    public static final /* synthetic */ long access$getCurrentTimestamp(FeatureNotificationService $this) {
        return $this.getCurrentTimestamp();
    }

    static {
        emitJobs$FU = AtomicReferenceFieldUpdater.newUpdater(FeatureNotificationService.class, Object.class, "emitJobs");
        sessionNotificationJobs$FU = AtomicReferenceFieldUpdater.newUpdater(FeatureNotificationService.class, Object.class, "sessionNotificationJobs");
    }
}

