/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;

public class PatternRuleXmlCreatorTest {
    @Test
    public void testToXML() throws IOException {
        PatternRuleId ruleId = new PatternRuleId("DEMO_RULE");
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        String xml = creator.toXML(ruleId, (Language)new Demo());
        Assert.assertEquals((Object)"<rule id=\"DEMO_RULE\" name=\"Find 'foo bar'\"><!-- a trivial demo rule that matches \"foo\" followed by \"bar\" -->\n  <pattern case_sensitive=\"no\">\n    <token>foo</token>\n    <token>bar</token>\n  </pattern>\n  <message>Did you mean <suggestion><match no=\"1\"/> fuu bah</suggestion>?</message>\n  <url>http://fake-server.org/foo-bar-error-explained</url>\n  <example>This is <marker>fuu bah</marker>.</example>\n  <example correction=\"foo fuu bah\">This is <marker>foo bar</marker>.</example>\n</rule>", (Object)xml);
    }

    @Test
    public void testToXMLWithRuleGroup() {
        PatternRuleId ruleId = new PatternRuleId("test_spacebefore");
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        String xml = creator.toXML(ruleId, (Language)new Demo());
        Assert.assertTrue((boolean)xml.contains("<rulegroup id=\"test_spacebefore\""));
        Assert.assertTrue((boolean)xml.contains("</rulegroup>"));
        Assert.assertTrue((boolean)xml.contains("<rule>"));
        Assert.assertTrue((boolean)xml.contains("<rule type=\"duplication\">"));
        Assert.assertTrue((boolean)xml.contains("<token>blah</token>"));
    }

    @Test
    public void testToXMLWithRuleGroupAndSubId1() {
        PatternRuleId ruleId = new PatternRuleId("test_spacebefore", "1");
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        String xml = creator.toXML(ruleId, (Language)new Demo());
        Assert.assertFalse((boolean)xml.contains("<rulegroup"));
        Assert.assertFalse((boolean)xml.contains("</rulegroup>"));
        Assert.assertTrue((boolean)xml.contains("<message>This is a dummy message 1.</message>"));
    }

    @Test
    public void testToXMLWithRuleGroupAndSubId2() {
        PatternRuleId ruleId = new PatternRuleId("test_spacebefore", "2");
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        String xml = creator.toXML(ruleId, (Language)new Demo());
        Assert.assertFalse((boolean)xml.contains("<rulegroup id=\"test_spacebefore\""));
        Assert.assertFalse((boolean)xml.contains("</rulegroup>"));
        Assert.assertTrue((boolean)xml.contains("<message>This is a dummy message 2.</message>"));
    }

    @Test
    public void testToXMLWithAntiPattern() {
        PatternRuleId ruleId = new PatternRuleId("DEMO_RULE_ANTIPATTERN");
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        String xml = creator.toXML(ruleId, (Language)new Demo());
        Assert.assertTrue((boolean)xml.contains("  <antipattern>\n    <token>bar</token>\n    <token>,</token>\n  </antipattern>\n"));
    }

    @Test
    public void testToXMLInvalidRuleId() {
        PatternRuleXmlCreator creator = new PatternRuleXmlCreator();
        PatternRuleId fakeRuleId = new PatternRuleId("FAKE_ID");
        try {
            creator.toXML(fakeRuleId, (Language)new Demo());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

