/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.execute.cmd.Constructor;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.util.Utilities;

public class ShellConstructor
implements Constructor {
    @NonNull
    private final File mavenHome;

    public ShellConstructor(@NonNull File mavenHome) {
        this.mavenHome = mavenHome;
    }

    @Override
    public List<String> construct() {
        Object ex = MavenSettings.isMavenDaemon(Paths.get(this.mavenHome.getPath(), new String[0])) ? "mvnd" : "mvn";
        ArrayList<String> command = new ArrayList<String>();
        if (Utilities.isWindows()) {
            command.add("cmd");
            command.add("/c");
            String version = MavenSettings.getCommandLineMavenVersion(this.mavenHome);
            if (null == version) {
                ex = (String)ex + ".bat";
            } else {
                String[] v = version.split("\\.");
                int major = Integer.parseInt(v[0]);
                int minor = Integer.parseInt(v[1]);
                ex = major < 3 || major == 3 && minor < 3 ? (String)ex + ".bat" : (String)ex + ".cmd";
            }
        }
        String quote = "\"";
        Path bin = Paths.get(this.mavenHome.getPath(), new String[]{"bin", ex}).toAbsolutePath();
        command.add(ShellConstructor.quoteSpaces(bin.toString(), quote));
        return command;
    }

    private static String quoteSpaces(String val, String quote) {
        if (Utilities.isWindows()) {
            return quote + val + quote;
        }
        return val;
    }
}

