/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListIdentityProviderGroupsRequest
extends BmcRequest<Void> {
    private String identityProviderId;
    private String page;
    private Integer limit;
    private String name;
    private IdentityProvider.LifecycleState lifecycleState;

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public IdentityProvider.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().identityProviderId(this.identityProviderId).page(this.page).limit(this.limit).name(this.name).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIdentityProviderGroupsRequest)) {
            return false;
        }
        ListIdentityProviderGroupsRequest other = (ListIdentityProviderGroupsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.identityProviderId, other.identityProviderId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIdentityProviderGroupsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String identityProviderId = null;
        private String page = null;
        private Integer limit = null;
        private String name = null;
        private IdentityProvider.LifecycleState lifecycleState = null;

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(IdentityProvider.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIdentityProviderGroupsRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIdentityProviderGroupsRequest build() {
            ListIdentityProviderGroupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIdentityProviderGroupsRequest buildWithoutInvocationCallback() {
            ListIdentityProviderGroupsRequest request = new ListIdentityProviderGroupsRequest();
            request.identityProviderId = this.identityProviderId;
            request.page = this.page;
            request.limit = this.limit;
            request.name = this.name;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

