/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class CaseDeclaration
extends BodyDeclaration {
    private final Identifier name;
    @NullAllowed
    private final Expression initializer;

    public CaseDeclaration(int start, int end, @NonNull Identifier name, @NullAllowed Expression initializer) {
        super(start, end, 0);
        this.name = name;
        this.initializer = initializer;
    }

    private CaseDeclaration(int start, int end, int modifier, @NonNull Identifier name, @NullAllowed Expression initializer, List<Attribute> attributes) {
        super(start, end, modifier, false, attributes);
        this.name = name;
        this.initializer = initializer;
    }

    public static CaseDeclaration create(CaseDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new CaseDeclaration(start, declaration.getEndOffset(), declaration.getModifier(), declaration.getName(), declaration.getInitializer(), attributes);
    }

    public Identifier getName() {
        return this.name;
    }

    @CheckForNull
    public Expression getInitializer() {
        return this.initializer;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        return sbAttributes.toString() + "case" + String.valueOf(this.name) + String.valueOf(this.initializer) == null ? "" : " = " + String.valueOf(this.initializer);
    }
}

