/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.widget.Widget;

public class TreeGraphLayoutUtility<N, E, P> {
    private final GraphPinScene<N, E, P> scene;
    private final int originX;
    private final int originY;
    private final int verticalGap;
    private final int horizontalGap;
    private final boolean vertical;

    private TreeGraphLayoutUtility(GraphPinScene<N, E, P> scene, int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        this.scene = scene;
        this.originX = originX;
        this.originY = originY;
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.vertical = vertical;
    }

    public static final <N, E, P> void performLayout(GraphPinScene<N, E, P> scene) {
        TreeGraphLayoutUtility.performLayout(scene, 100, 100, 50, 50, true);
    }

    public static final <N, E, P> void performLayout(GraphPinScene<N, E, P> graph, int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        Collection allNodes = graph.getNodes();
        HashSet unresolvedNodes = new HashSet(allNodes);
        HashMap node2connected = new HashMap();
        for (Object node : unresolvedNodes) {
            HashSet connected = new HashSet();
            for (Object edge : graph.getEdges()) {
                Object pinTarget;
                Object pinSource = graph.getEdgeSource(edge);
                if (graph.getPinNode(pinSource).equals(node)) {
                    connected.add(node);
                }
                if (!graph.getPinNode(pinTarget = graph.getEdgeTarget(edge)).equals(node)) continue;
                connected.add(node);
            }
            node2connected.put(node, connected);
        }
        Object root = TreeGraphLayoutUtility.findNodeWithMaxEdges(unresolvedNodes, node2connected);
        TreeGraphLayoutUtility utility = new TreeGraphLayoutUtility(graph, 100, 100, 50, 50, true);
        utility.layout(root);
    }

    public final void layout(N rootNode) {
        if (rootNode == null) {
            return;
        }
        Collection allNodes = this.scene.getNodes();
        ArrayList nodesToResolve = new ArrayList(allNodes);
        HashSet loadedSet = new HashSet();
        Node root = new Node(rootNode, loadedSet);
        nodesToResolve.removeAll(loadedSet);
        if (this.vertical) {
            root.allocateHorizontally();
            root.resolveVertically(this.originX, this.originY);
        } else {
            root.allocateVertically();
            root.resolveHorizontally(this.originX, this.originY);
        }
        HashMap resultPosition = new HashMap();
        root.upload(resultPosition);
        for (Object e : nodesToResolve) {
            Point position = new Point();
            resultPosition.put(e, position);
        }
        for (Map.Entry entry : resultPosition.entrySet()) {
            this.scene.findWidget(entry.getKey()).setPreferredLocation((Point)entry.getValue());
        }
        this.scene.validate();
    }

    protected Collection<N> resolveChildren(N node) {
        HashSet<N> nodes = new HashSet<N>();
        Collection allEdges = this.scene.getEdges();
        for (Object edge : allEdges) {
            Object pinSource = this.scene.getEdgeSource(edge);
            if (!this.scene.getPinNode(pinSource).equals(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static <N> N findNodeWithMaxEdges(Set<N> unresolvedNodes, Map<N, Collection<N>> node2connected) {
        N bestNode = null;
        int bestCount = Integer.MIN_VALUE;
        for (N node : unresolvedNodes) {
            int i = node2connected.get(node).size();
            if (i <= bestCount) continue;
            bestNode = node;
            bestCount = i;
        }
        return bestNode;
    }

    private class Node {
        private final N myNode;
        private final List<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(N node, Set<N> loadedSet) {
            this.myNode = node;
            loadedSet.add(node);
            Collection list = TreeGraphLayoutUtility.this.resolveChildren(node);
            this.children = new ArrayList<Node>();
            for (Object child : list) {
                if (loadedSet.contains(child)) continue;
                this.children.add(new Node(child, loadedSet));
            }
        }

        private int allocateHorizontally() {
            Widget widget = TreeGraphLayoutUtility.this.scene.findWidget(this.myNode);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayoutUtility.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int paramX, int paramY) {
            int x = paramX;
            int y = paramY;
            this.point = new Point(x + this.totalSpace / 2, y - this.relativeBounds.y);
            x += (this.totalSpace - this.space) / 2;
            y += this.relativeBounds.height + TreeGraphLayoutUtility.this.verticalGap;
            for (Node child : this.children) {
                child.resolveVertically(x, y);
                x += child.totalSpace + TreeGraphLayoutUtility.this.horizontalGap;
            }
        }

        private int allocateVertically() {
            Widget widget = TreeGraphLayoutUtility.this.scene.findWidget(this.myNode);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayoutUtility.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int paramX, int paramY) {
            int x = paramX;
            int y = paramY;
            this.point = new Point(x - this.relativeBounds.x, y + this.totalSpace / 2);
            x += this.relativeBounds.width + TreeGraphLayoutUtility.this.horizontalGap;
            y += (this.totalSpace - this.space) / 2;
            for (Node child : this.children) {
                child.resolveHorizontally(x, y);
                y += child.totalSpace + TreeGraphLayoutUtility.this.verticalGap;
            }
        }

        private void upload(Map<N, Point> result) {
            result.put(this.myNode, this.point);
            for (Node child : this.children) {
                child.upload(result);
            }
        }
    }
}

