/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public final class JXTableRowHeader
extends JComponent {
    private final PropertyChangeListener backingTableListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("rowHeight")) {
                JXTableRowHeader.this.headerTable.setRowHeight((Integer)pce.getNewValue());
            }
        }
    };
    private static final Icon ICON_RIGHT_ARROW = new Icon(){

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 4, y + 4, x + 4, y + 4);
            g.translate(x + 4, y + 4);
            g.fillPolygon(new Polygon(new int[]{0, 5, 0}, new int[]{-5, 0, 5}, 3));
        }
    };
    private static final Icon ICON_CLEAR = new Icon(){

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };
    private final CountingTableModel ctm;
    private final JTable headerTable;
    private final JTable backingTable;

    public JTableHeader getTableHeader() {
        JTableHeader header = this.headerTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public JXTableRowHeader(JTable table) {
        assert (table != null) : "JXTableRowHeader needs to be instanciated with a JXTable";
        this.backingTable = table;
        this.ctm = new CountingTableModel(this.backingTable);
        this.headerTable = new JXTableDecorator(this.ctm, new InternalTableColumnModel());
        this.backingTable.addPropertyChangeListener(this.backingTableListener);
        this.headerTable.setRowHeight(this.backingTable.getRowHeight());
        this.headerTable.setSelectionModel(this.backingTable.getSelectionModel());
        this.setLayout(new GridLayout(1, 1));
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.getTableHeader().setReorderingAllowed(false);
        this.headerTable.getTableHeader().setResizingAllowed(false);
        this.headerTable.getTableHeader().setToolTipText("Row number");
        this.headerTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RowSorter<? extends TableModel> sorter = JXTableRowHeader.this.backingTable.getRowSorter();
                if (sorter instanceof DefaultRowSorter) {
                    ((DefaultRowSorter)sorter).setSortKeys(null);
                }
            }
        });
        this.add(this.headerTable);
        TableColumn column = this.headerTable.getColumnModel().getColumn(0);
        this.headerTable.doLayout();
        TableCellRenderer defaultRenderer = this.createDefaultRenderer();
        Component c = defaultRenderer.getTableCellRendererComponent(this.headerTable, "00000", false, false, 0, 0);
        column.setPreferredWidth((int)c.getMinimumSize().getWidth() + 10);
        column.setCellRenderer(this.createDefaultRenderer());
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
        this.headerTable.setInheritsPopupMenu(true);
        this.headerTable.setShowGrid(true);
        this.headerTable.setGridColor(ResultSetJXTable.GRID_COLOR);
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new RowHeaderColumnRenderer();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.headerTable.getToolTipText(event);
    }

    private static class CountingTableModel
    implements TableModel,
    PropertyChangeListener,
    TableModelListener,
    RowSorterListener {
        private static final String PROP_ROW_SORTER = "rowSorter";
        private static final String PROP_SORTER = "sorter";
        private static final String PROP_MODEL = "model";
        private int count;
        private TableModel backingTableModel;
        private RowSorter<?> backingSorter;
        private final Set<TableModelListener> listeners = new HashSet<TableModelListener>();
        private final JTable backingTable;

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (PROP_ROW_SORTER.equals(propertyName) || PROP_SORTER.equals(propertyName)) {
                if (this.backingSorter != null) {
                    this.backingSorter.removeRowSorterListener(this);
                }
                this.backingSorter = null;
                if (pce.getNewValue() != null) {
                    this.backingSorter = (RowSorter)pce.getNewValue();
                    this.backingSorter.addRowSorterListener(this);
                }
                this.tableDataChanged();
            } else if (PROP_MODEL.equals(propertyName)) {
                if (this.backingTableModel != null) {
                    this.backingTableModel.removeTableModelListener(this);
                }
                this.backingTableModel = (TableModel)pce.getNewValue();
                if (this.backingTableModel != null) {
                    this.backingTableModel.addTableModelListener(this);
                }
                this.tableDataChanged();
            }
        }

        public CountingTableModel(JTable table) {
            this.backingTable = table;
            this.backingSorter = this.backingTable.getRowSorter();
            if (this.backingSorter != null) {
                this.backingSorter.addRowSorterListener(this);
            }
            this.backingTable.addPropertyChangeListener(this);
            this.backingTableModel = table.getModel();
            this.backingTableModel.addTableModelListener(this);
            this.setCount(this.backingTable.getRowCount());
        }

        private void fireTableDataChanged() {
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this));
            }
        }

        private void setCount(int count) {
            if (count != this.count) {
                this.count = count;
                this.fireTableDataChanged();
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tl) {
            this.listeners.add(tl);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int i) {
            return "Row number";
        }

        @Override
        public int getRowCount() {
            return this.count;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.backingTableModel instanceof DataViewTableUIModel) {
                try {
                    int modelRow = this.backingTable.convertRowIndexToModel(row);
                    return Integer.toString(((DataViewTableUIModel)this.backingTableModel).getTotalRowOffset(modelRow) + 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    return null;
                }
            }
            return Integer.toString(row + 1);
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener tl) {
            this.listeners.remove(tl);
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
            throw new NoSuchMethodError();
        }

        private void tableDataChanged() {
            SwingUtilities.invokeLater(() -> {
                this.setCount(this.backingTable.getRowCount());
                this.fireTableDataChanged();
            });
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.tableDataChanged();
        }

        @Override
        public void sorterChanged(RowSorterEvent rse) {
            this.tableDataChanged();
        }
    }

    private static class InternalTableColumnModel
    extends DefaultTableColumnModel {
        public InternalTableColumnModel() {
            TableColumn col = new TableColumn(0, 75);
            col.setHeaderValue("#");
            this.addColumn(col);
        }
    }

    private class RowHeaderColumnRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel iconLabel = new JLabel(JXTableRowHeader.access$100());
        private final JLabel textLabel = new JLabel("");

        public RowHeaderColumnRenderer() {
            GridBagConstraints iconConstraints = new GridBagConstraints();
            iconConstraints.anchor = 512;
            iconConstraints.fill = 0;
            iconConstraints.weightx = 0.0;
            iconConstraints.weighty = 0.0;
            GridBagConstraints labelConstraints = new GridBagConstraints();
            labelConstraints.anchor = 512;
            labelConstraints.fill = 2;
            labelConstraints.weightx = 1.0;
            labelConstraints.weighty = 0.0;
            this.setLayout(new GridBagLayout());
            this.add((Component)this.iconLabel, iconConstraints);
            this.add((Component)this.textLabel, labelConstraints);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            this.textLabel.setText(value == null ? "" : value.toString());
            if (isSelected) {
                this.iconLabel.setIcon(ICON_RIGHT_ARROW);
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.iconLabel.setIcon(ICON_CLEAR);
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }
}

