/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.Util;

public final class TreeName {
    private final String prefix;
    private final String name;
    private final String rawName;

    public TreeName(String prefix, String name) throws InvalidArgumentException {
        this.checkPrefix(prefix);
        this.checkName(name);
        this.prefix = prefix;
        this.name = name;
        this.rawName = TreeName.getQualifiedName(prefix, name);
    }

    public TreeName(String rawName) throws InvalidArgumentException {
        this.checkRawName(rawName);
        this.prefix = TreeName.getPrefix(rawName);
        this.name = TreeName.getName(rawName);
        this.rawName = rawName;
    }

    private static String getPrefix(String rawName) {
        int i = rawName.indexOf(":");
        if (i < 0) {
            return "";
        }
        return rawName.substring(0, i);
    }

    private static String getName(String rawName) {
        int i = rawName.indexOf(":");
        if (i < 0) {
            return rawName;
        }
        return rawName.substring(i + 1);
    }

    private static String getQualifiedName(String prefix, String name) {
        if ("".equals(prefix)) {
            return name;
        }
        return prefix + ":" + name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private void checkPrefix(String prefix) throws InvalidArgumentException {
        if (prefix == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    public String getName() {
        return this.name;
    }

    private void checkName(String name) throws InvalidArgumentException {
        if (name == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    public String getQualifiedName() {
        return this.rawName;
    }

    private void checkRawName(String rawName) throws InvalidArgumentException {
        if (rawName == null) {
            throw this.createInvalidNullArgumentException();
        }
    }

    private InvalidArgumentException createInvalidNullArgumentException() {
        return new InvalidArgumentException(Util.THIS.getString("EXC_invalid_null_value"), new NullPointerException());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TreeName) {
            return this.rawName.equals(((TreeName)obj).rawName);
        }
        return false;
    }

    public int hashCode() {
        return this.rawName.hashCode();
    }

    public String toString() {
        return this.rawName;
    }
}

