/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.net.URL;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.ClientProjectEnhancedBrowserImpl;
import org.netbeans.modules.web.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.validation.RunProjectValidator;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class BrowserActionProvider
implements ActionProvider {
    private final ClientSideProject project;
    private final BrowserSupport support;
    private ClientProjectEnhancedBrowserImpl cfg;

    public BrowserActionProvider(ClientSideProject project, BrowserSupport support, ClientProjectEnhancedBrowserImpl cfg) {
        this.project = project;
        this.support = support;
        this.cfg = cfg;
    }

    public String[] getSupportedActions() {
        return new String[]{"run", "run.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if (this.project.isUsingEmbeddedServer()) {
            WebServer.getWebserver().start((Project)this.project, this.project.getSiteRootFolder(), this.project.getWebContextRoot());
        } else {
            WebServer.getWebserver().stop((Project)this.project);
        }
        if ("run".equals(command)) {
            if (!this.validateRun(true)) {
                return;
            }
            Pair<FileObject, String> startFileWithFragment = this.getStartFileWithFragment();
            if (startFileWithFragment == null) {
                return;
            }
            FileObject fo = (FileObject)startFileWithFragment.first();
            String fragment = (String)startFileWithFragment.second();
            if (fo == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BrowserActionProvider.class, (String)"MAIN_FILE", (Object)this.project.getStartFile())));
                CustomizerProviderImpl cust = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
                cust.showCustomizer("RUN");
                startFileWithFragment = this.getStartFileWithFragment();
                if (startFileWithFragment == null) {
                    return;
                }
                fo = (FileObject)startFileWithFragment.first();
                fragment = (String)startFileWithFragment.second();
                if (fo == null) {
                    return;
                }
            }
            this.browseFile(this.support, fo, fragment);
        } else if ("run.single".equals(command)) {
            if (!this.validateRun(false)) {
                return;
            }
            FileObject fo = this.getFile(context);
            if (fo != null) {
                this.browseFile(this.support, fo);
            }
        }
    }

    @CheckForNull
    private Pair<FileObject, String> getStartFileWithFragment() {
        FileObject siteRoot = this.project.getSiteRootFolder();
        if (siteRoot == null) {
            ProjectProblems.showAlert((Project)this.project);
            return null;
        }
        String[] parts = ClientSideProjectUtilities.splitPathAndFragment(this.project.getStartFile());
        return Pair.of((Object)siteRoot.getFileObject(parts[0]), (Object)parts[1]);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return true;
    }

    private FileObject getFile(Lookup context) {
        return (FileObject)context.lookup(FileObject.class);
    }

    private void browseFile(BrowserSupport bs, FileObject fo) {
        this.browseFile(bs, fo, "");
    }

    private void browseFile(BrowserSupport bs, FileObject fo, String fragment) {
        if (ClientSideProjectUtilities.isParentOrItself(this.project.getSiteRootFolder(), fo)) {
            URL url = ServerURLMapping.toServer((Project)this.project, (FileObject)fo);
            if (fragment.length() > 0) {
                url = WebUtils.stringToUrl((String)(WebUtils.urlToString((URL)url) + fragment));
            }
            bs.load(url, fo);
        } else {
            URL url = fo.toURL();
            WebBrowser wb = this.project.getProjectWebBrowser();
            WebBrowserFeatures features = new WebBrowserFeatures(false, false, false, false, false, false);
            wb.createNewBrowserPane(features).showURL(url);
        }
    }

    private boolean validateRun(boolean validateStartFile) {
        boolean errors;
        ValidationResult result = new RunProjectValidator().validate(this.project, validateStartFile).getResult();
        boolean bl = errors = result.hasErrors() || result.hasWarnings();
        if (errors) {
            CustomizerProviderImpl cust = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            cust.showCustomizer("RUN");
        }
        return !errors;
    }
}

