/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

abstract class TimelineXYItem
extends SynchronousXYItem {
    private int lastIndex;
    private int lastValuesCount;
    private final LongRect bounds;
    private long initialMinY;
    private long initialMaxY;
    private long minY;
    private long maxY;
    private int itemIndex;

    TimelineXYItem(String name, int itemIndex) {
        this(name, Long.MAX_VALUE, itemIndex);
    }

    TimelineXYItem(String name, long initialMinY, int itemIndex) {
        this(name, initialMinY, Long.MIN_VALUE, itemIndex);
    }

    TimelineXYItem(String name, long initialMinY, long initialMaxY, int itemIndex) {
        super(name, initialMinY, initialMaxY);
        this.initialMinY = initialMinY;
        this.initialMaxY = initialMaxY;
        this.minY = Long.MAX_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.bounds = new LongRect();
        this.lastIndex = -1;
        this.setIndex(itemIndex);
    }

    final void setIndex(int itemIndex) {
        this.itemIndex = itemIndex;
    }

    final int getIndex() {
        return this.itemIndex;
    }

    public XYItemChange valuesChanged() {
        int valuesCount = this.getValuesCount();
        int index = valuesCount - 1;
        XYItemChange.Default change = null;
        if (index > -1) {
            int dirtyIndex;
            LongRect oldBounds = new LongRect(this.bounds);
            LongRect dirtyBounds = new LongRect();
            boolean initBounds = this.lastIndex == -1;
            for (int i = dirtyIndex = this.lastIndex == -1 ? 0 : this.lastIndex; i <= index; ++i) {
                long timestamp = this.getXValue(i);
                long value = this.getYValue(i);
                this.minY = Math.min(value, this.minY);
                this.maxY = Math.max(value, this.maxY);
                if (initBounds) {
                    this.bounds.x = timestamp;
                    this.bounds.y = Math.min(value, this.initialMinY);
                    this.bounds.width = 0L;
                    this.bounds.height = Math.max(value, this.initialMaxY) - this.bounds.y;
                    initBounds = false;
                } else {
                    LongRect.add((LongRect)this.bounds, (long)timestamp, (long)value);
                    if (valuesCount == this.lastValuesCount) {
                        this.bounds.x = this.getXValue(0);
                        this.bounds.width = this.getXValue(valuesCount - 1) - this.bounds.x;
                    }
                }
                if (i == dirtyIndex) {
                    dirtyBounds.x = timestamp;
                    dirtyBounds.y = value;
                    dirtyBounds.width = this.getXValue(index) - dirtyBounds.x;
                    continue;
                }
                long dirtyY = dirtyBounds.y;
                dirtyBounds.y = Math.min(dirtyY, value);
                dirtyBounds.height = Math.max(dirtyY, value) - dirtyBounds.y;
            }
            int indexesCount = index - this.lastIndex;
            int[] indexes = new int[indexesCount];
            for (int i = 0; i < indexesCount; ++i) {
                indexes[i] = this.lastIndex + 1 + i;
            }
            change = new XYItemChange.Default((XYItem)this, indexes, oldBounds, new LongRect(this.bounds), dirtyBounds);
        } else {
            this.minY = Long.MAX_VALUE;
            this.maxY = Long.MIN_VALUE;
            LongRect oldBounds = new LongRect(this.bounds);
            LongRect.set((LongRect)this.bounds, (long)0L, (long)0L, (long)0L, (long)0L);
            change = new XYItemChange.Default((XYItem)this, new int[]{-1}, oldBounds, new LongRect(this.bounds), oldBounds);
        }
        this.lastIndex = index;
        this.lastValuesCount = valuesCount;
        return change;
    }

    public long getMinYValue() {
        return this.minY;
    }

    public long getMaxYValue() {
        return this.maxY;
    }

    public LongRect getBounds() {
        if (this.getValuesCount() > 0) {
            return this.bounds;
        }
        return this.getInitialBounds();
    }
}

