/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;

public class CustomBarCellRenderer
extends EnhancedTableCellRenderer {
    public static final Color BAR_FOREGROUND_COLOR = new Color(195, 41, 41);
    protected double relValue;
    protected long max;
    protected long min;

    public CustomBarCellRenderer(long min, long max) {
        this.setMinimum(min);
        this.setMaximum(max);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void setMaximum(long n) {
        this.max = n;
    }

    public void setMinimum(long n) {
        this.min = n;
    }

    public void setRelValue(double n) {
        this.relValue = n;
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        g.setColor(BAR_FOREGROUND_COLOR);
        g.fillRect(insets.left, insets.top, (int)Math.round(this.relValue * (double)(this.getWidth() - insets.right - insets.left)), this.getHeight() - insets.bottom - insets.top);
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        if (value instanceof Long) {
            this.setRelValue(this.calculateViewValue((Long)value));
        } else if (value instanceof Number) {
            this.setRelValue(this.calculateViewValue(((Number)value).doubleValue()));
        } else if (value instanceof String) {
            this.setRelValue(this.calculateViewValue(Double.parseDouble((String)value)));
        } else {
            this.setRelValue(this.min);
        }
    }

    protected double calculateViewValue(long n) {
        return (double)(n - this.min) / (double)(this.max - this.min);
    }

    protected double calculateViewValue(double n) {
        return (n - (double)this.min) / (double)(this.max - this.min);
    }
}

