/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.UIExceptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.GraphicsUtils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FontEditor
implements PropertyEditor,
XMLPropertyEditor {
    static final Integer[] sizes = new Integer[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    static final String[] styles = new String[]{NbBundle.getMessage(FontEditor.class, (String)"CTL_Plain"), NbBundle.getMessage(FontEditor.class, (String)"CTL_Bold"), NbBundle.getMessage(FontEditor.class, (String)"CTL_Italic"), NbBundle.getMessage(FontEditor.class, (String)"CTL_BoldItalic")};
    private Font font;
    private String fontName;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static String[] fonts;
    public static final String XML_FONT = "Font";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_SIZE = "size";

    @Override
    public Object getValue() {
        return this.font;
    }

    @Override
    public void setValue(Object object) {
        if (this.font != null && this.font.equals(object)) {
            return;
        }
        if (this.font == null && object == null) {
            return;
        }
        if (object instanceof Font) {
            this.font = (Font)object;
        } else if (object == null) {
            this.font = null;
        } else assert (false) : "Object " + object + " is instanceof Font or null";
        this.fontName = this.font != null ? this.font.getName() + " " + this.font.getSize() + " " + this.getStyleName(this.font.getStyle()) : null;
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public String getAsText() {
        return this.fontName;
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String getJavaInitializationString() {
        return "new java.awt.Font(\"" + this.font.getName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.paintText(graphics, rectangle, this.fontName == null ? "null" : this.fontName);
    }

    private void paintText(Graphics graphics, Rectangle rectangle, String string) {
        Font font;
        GraphicsUtils.configureDefaultRenderingHints((Graphics)graphics);
        Font font2 = graphics.getFont();
        if (this.font == null) {
            this.setValue(null);
        }
        Font font3 = font = this.font == null ? font2 : this.font;
        assert (font != null) : "paintFont must exist.";
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (fontMetrics.getHeight() > rectangle.height) {
            font = Utilities.isMac() ? new Font(font.getName(), font.getStyle(), 12) : font.deriveFont(12.0f);
            fontMetrics = graphics.getFontMetrics(font);
        }
        graphics.setFont(font);
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        graphics.setFont(font2);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new FontPanel();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    String getStyleName(int n) {
        if ((n & 1) > 0) {
            if ((n & 2) > 0) {
                return NbBundle.getMessage(FontEditor.class, (String)"CTL_BoldItalic");
            }
            return NbBundle.getMessage(FontEditor.class, (String)"CTL_Bold");
        }
        if ((n & 2) > 0) {
            return NbBundle.getMessage(FontEditor.class, (String)"CTL_Italic");
        }
        return NbBundle.getMessage(FontEditor.class, (String)"CTL_Plain");
    }

    private static String[] getFonts() {
        if (fonts == null) {
            try {
                fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            }
            catch (RuntimeException runtimeException) {
                fonts = new String[0];
                if (Utilities.isMac()) {
                    String string = NbBundle.getMessage(FontEditor.class, (String)"MSG_AppleBug");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
                }
                throw runtimeException;
            }
        }
        return fonts;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_FONT.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
            String string2 = namedNodeMap.getNamedItem(ATTR_STYLE).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(ATTR_SIZE).getNodeValue();
            this.setValue(new Font(string, Integer.parseInt(string2), Integer.parseInt(string3)));
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        if (this.font == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(FontEditor.class, (String)"MSG_FontIsNotInitialized"));
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
            return null;
        }
        Element element = document.createElement(XML_FONT);
        element.setAttribute(ATTR_NAME, this.font.getName());
        element.setAttribute(ATTR_STYLE, Integer.toString(this.font.getStyle()));
        element.setAttribute(ATTR_SIZE, Integer.toString(this.font.getSize()));
        return element;
    }

    class FontPanel
    extends JPanel {
        JTextField tfFont;
        JTextField tfStyle;
        JTextField tfSize;
        JList lFont;
        JList lStyle;
        JList lSize;
        boolean dontSetValue = false;
        static final long serialVersionUID = 8377025140456676594L;

        FontPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            Font font = (Font)FontEditor.this.getValue();
            if (font == null) {
                font = FontEditor.getFonts().length > 0 ? new Font(fonts[0], 0, 10) : UIManager.getFont("Label.font");
            }
            this.lFont = new JList<String>(FontEditor.getFonts());
            this.lFont.setSelectionMode(0);
            this.lFont.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditor.class, (String)"ACSD_CTL_Font"));
            this.lStyle = new JList<String>(styles);
            this.lStyle.setSelectionMode(0);
            this.lStyle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditor.class, (String)"ACSD_CTL_FontStyle"));
            this.lSize = new JList<Integer>(sizes);
            this.lSize.setSelectionMode(0);
            this.lSize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditor.class, (String)"ACSD_CTL_Size"));
            this.tfSize = new JTextField(String.valueOf(font.getSize()));
            this.tfSize.getAccessibleContext().setAccessibleDescription(this.lSize.getAccessibleContext().getAccessibleDescription());
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FontEditor.class, (String)"ACSD_FontCustomEditor"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(FontEditor.class, (String)"CTL_Font"));
            jLabel.setLabelFor(this.lFont);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(FontEditor.class, (String)"CTL_FontStyle"));
            jLabel.setLabelFor(this.lStyle);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.gridwidth = 0;
            jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(FontEditor.class, (String)"CTL_Size"));
            jLabel.setLabelFor(this.tfSize);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this.tfFont = new JTextField(font.getName());
            this.tfFont.setEnabled(false);
            gridBagLayout.setConstraints(this.tfFont, gridBagConstraints);
            this.add(this.tfFont);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.tfStyle = new JTextField(FontEditor.this.getStyleName(font.getStyle()));
            this.tfStyle.setEnabled(false);
            gridBagLayout.setConstraints(this.tfStyle, gridBagConstraints);
            this.add(this.tfStyle);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridwidth = 0;
            this.tfSize.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        FontPanel.this.setValue();
                    }
                }
            });
            this.tfSize.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (FontPanel.this.dontSetValue) {
                        return;
                    }
                    FontPanel.this.dontSetValue = true;
                    Component component = focusEvent.getOppositeComponent();
                    if (component != null) {
                        if (component instanceof JButton) {
                            if (((JButton)component).getText().equals(NbBundle.getMessage(FontEditor.class, (String)"CTL_OK"))) {
                                FontPanel.this.setValue();
                            }
                        } else {
                            FontPanel.this.setValue();
                        }
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FontPanel.this.dontSetValue = false;
                }
            });
            gridBagLayout.setConstraints(this.tfSize, gridBagConstraints);
            this.add(this.tfSize);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.lFont.setVisibleRowCount(5);
            this.lFont.setSelectedValue(font.getName(), true);
            this.lFont.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!FontPanel.this.lFont.isSelectionEmpty() && FontEditor.getFonts().length > 0) {
                        int n = FontPanel.this.lFont.getSelectedIndex();
                        FontPanel.this.tfFont.setText(FontEditor.getFonts()[n]);
                        FontPanel.this.setValue();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lFont);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.positionScrollPaneOnSelected(jScrollPane, this.lFont);
            this.add(jScrollPane);
            this.lStyle.setVisibleRowCount(5);
            this.lStyle.setSelectedValue(FontEditor.this.getStyleName(font.getStyle()), true);
            this.lStyle.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!FontPanel.this.lStyle.isSelectionEmpty()) {
                        int n = FontPanel.this.lStyle.getSelectedIndex();
                        FontPanel.this.tfStyle.setText(styles[n]);
                        FontPanel.this.setValue();
                    }
                }
            });
            jScrollPane = new JScrollPane(this.lStyle);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.positionScrollPaneOnSelected(jScrollPane, this.lStyle);
            this.add(jScrollPane);
            gridBagConstraints.gridwidth = 0;
            this.lSize.getAccessibleContext().setAccessibleName(this.tfSize.getAccessibleContext().getAccessibleName());
            this.lSize.setVisibleRowCount(5);
            this.updateSizeList(font.getSize());
            this.lSize.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!FontPanel.this.lSize.isSelectionEmpty()) {
                        int n = FontPanel.this.lSize.getSelectedIndex();
                        FontPanel.this.tfSize.setText(String.valueOf(sizes[n]));
                        FontPanel.this.setValue();
                    }
                }
            });
            jScrollPane = new JScrollPane(this.lSize);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.positionScrollPaneOnSelected(jScrollPane, this.lSize);
            this.add(jScrollPane);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 0.0;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(" " + NbBundle.getMessage(FontEditor.class, (String)"CTL_Preview") + " "));
            JPanel jPanel2 = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(150, 60);
                }

                @Override
                public void paint(Graphics graphics) {
                    FontEditor.this.paintText(graphics, new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1), NbBundle.getMessage(FontEditor.class, (String)"MSG_Preview"));
                }
            };
            jPanel.add("Center", jPanel2);
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }

        private void updateSizeList(int n) {
            if (Arrays.asList(sizes).contains(n)) {
                this.lSize.setSelectedValue(n, true);
            } else {
                this.lSize.clearSelection();
            }
        }

        private void setValue() {
            int n = 12;
            try {
                n = Integer.parseInt(this.tfSize.getText());
                if (n <= 0) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    UIExceptions.annotateUser(illegalArgumentException, null, n == 0 ? NbBundle.getMessage(FontEditor.class, (String)"CTL_InvalidValueWithParam", (Object)this.tfSize.getText()) : NbBundle.getMessage(FontEditor.class, (String)"CTL_NegativeSize"), null, null);
                    this.tfSize.setText(String.valueOf(FontEditor.this.font.getSize()));
                    throw illegalArgumentException;
                }
                this.updateSizeList(n);
            }
            catch (NumberFormatException numberFormatException) {
                UIExceptions.annotateUser(numberFormatException, null, NbBundle.getMessage(FontEditor.class, (String)"CTL_InvalidValueWithExc", (Object)numberFormatException), null, null);
                this.tfSize.setText(String.valueOf(FontEditor.this.font.getSize()));
                throw numberFormatException;
            }
            int n2 = this.lStyle.getSelectedIndex();
            int n3 = 0;
            switch (n2) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    n3 = 3;
                }
            }
            FontEditor.this.setValue(new Font(this.tfFont.getText(), n3, n));
            this.invalidate();
            Container container = this.getParent();
            if (container != null) {
                ((Component)container).validate();
            }
            this.repaint();
        }

        private void positionScrollPaneOnSelected(JScrollPane jScrollPane, JList jList) {
            if (jList.getSelectedIndex() != -1) {
                int n = jList.getSelectedIndex() - jList.getVisibleRowCount() / 2;
                Rectangle rectangle = jList.getCellBounds(n < 0 ? 0 : n, jList.getSelectedIndex());
                jScrollPane.getViewport().setViewPosition(new Point(rectangle.x, rectangle.y));
            }
        }
    }
}

