﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resource-groups/ResourceGroups_EXPORTS.h>
#include <aws/resource-groups/model/ResourceQuery.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResourceGroups {
namespace Model {
class StartTagSyncTaskResult {
 public:
  AWS_RESOURCEGROUPS_API StartTagSyncTaskResult() = default;
  AWS_RESOURCEGROUPS_API StartTagSyncTaskResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESOURCEGROUPS_API StartTagSyncTaskResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon resource name (ARN) of the application group for which you want to
   * add or remove resources. </p>
   */
  inline const Aws::String& GetGroupArn() const { return m_groupArn; }
  template <typename GroupArnT = Aws::String>
  void SetGroupArn(GroupArnT&& value) {
    m_groupArnHasBeenSet = true;
    m_groupArn = std::forward<GroupArnT>(value);
  }
  template <typename GroupArnT = Aws::String>
  StartTagSyncTaskResult& WithGroupArn(GroupArnT&& value) {
    SetGroupArn(std::forward<GroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the application group to onboard and sync resources.</p>
   */
  inline const Aws::String& GetGroupName() const { return m_groupName; }
  template <typename GroupNameT = Aws::String>
  void SetGroupName(GroupNameT&& value) {
    m_groupNameHasBeenSet = true;
    m_groupName = std::forward<GroupNameT>(value);
  }
  template <typename GroupNameT = Aws::String>
  StartTagSyncTaskResult& WithGroupName(GroupNameT&& value) {
    SetGroupName(std::forward<GroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon resource name (ARN) of the new tag-sync task. </p>
   */
  inline const Aws::String& GetTaskArn() const { return m_taskArn; }
  template <typename TaskArnT = Aws::String>
  void SetTaskArn(TaskArnT&& value) {
    m_taskArnHasBeenSet = true;
    m_taskArn = std::forward<TaskArnT>(value);
  }
  template <typename TaskArnT = Aws::String>
  StartTagSyncTaskResult& WithTaskArn(TaskArnT&& value) {
    SetTaskArn(std::forward<TaskArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tag key of the tag-sync task. </p>
   */
  inline const Aws::String& GetTagKey() const { return m_tagKey; }
  template <typename TagKeyT = Aws::String>
  void SetTagKey(TagKeyT&& value) {
    m_tagKeyHasBeenSet = true;
    m_tagKey = std::forward<TagKeyT>(value);
  }
  template <typename TagKeyT = Aws::String>
  StartTagSyncTaskResult& WithTagKey(TagKeyT&& value) {
    SetTagKey(std::forward<TagKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tag value of the tag-sync task. </p>
   */
  inline const Aws::String& GetTagValue() const { return m_tagValue; }
  template <typename TagValueT = Aws::String>
  void SetTagValue(TagValueT&& value) {
    m_tagValueHasBeenSet = true;
    m_tagValue = std::forward<TagValueT>(value);
  }
  template <typename TagValueT = Aws::String>
  StartTagSyncTaskResult& WithTagValue(TagValueT&& value) {
    SetTagValue(std::forward<TagValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResourceQuery& GetResourceQuery() const { return m_resourceQuery; }
  template <typename ResourceQueryT = ResourceQuery>
  void SetResourceQuery(ResourceQueryT&& value) {
    m_resourceQueryHasBeenSet = true;
    m_resourceQuery = std::forward<ResourceQueryT>(value);
  }
  template <typename ResourceQueryT = ResourceQuery>
  StartTagSyncTaskResult& WithResourceQuery(ResourceQueryT&& value) {
    SetResourceQuery(std::forward<ResourceQueryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon resource name (ARN) of the role assumed by the service to tag and
   * untag resources on your behalf.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  StartTagSyncTaskResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartTagSyncTaskResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_groupArn;
  bool m_groupArnHasBeenSet = false;

  Aws::String m_groupName;
  bool m_groupNameHasBeenSet = false;

  Aws::String m_taskArn;
  bool m_taskArnHasBeenSet = false;

  Aws::String m_tagKey;
  bool m_tagKeyHasBeenSet = false;

  Aws::String m_tagValue;
  bool m_tagValueHasBeenSet = false;

  ResourceQuery m_resourceQuery;
  bool m_resourceQueryHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResourceGroups
}  // namespace Aws
