/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.util.ImageUtils;

public final class RiverAnimationImageCreator {
    private final ImageLibrary lib;
    private final ImageCache imageCache;

    public RiverAnimationImageCreator(ImageLibrary lib, ImageCache imageCache) {
        this.lib = lib;
        this.imageCache = imageCache;
    }

    public BufferedImage getAnimatedScaledRiverTerrainImage(Tile tile, long ticks) {
        ImageResource riverPebblesImageResource = RiverAnimationImageCreator.getRiverPebblesImageResource();
        if (riverPebblesImageResource == null) {
            return null;
        }
        List<Direction> riverTransitions = this.determineRiverTransitionsUsingStyle(tile);
        String riverVariationKey = this.directionsToString(riverTransitions);
        ImageResource riverWaterImageResource = ImageCache.getImageResource("image.tile.river.water");
        int riverVariationNumber = riverWaterImageResource.getVariationNumberForTick(ticks);
        int magnitude = tile.getRiver().getMagnitude();
        String minorString = magnitude <= 1 ? ".minor" : "";
        List<Direction> minorToMajorTransitions = this.determineMinorToMajorRiverTransitions(tile, riverTransitions);
        String generatedKey = riverWaterImageResource.getCachingKey() + ".river." + minorString + this.directionsToString(minorToMajorTransitions) + "." + riverVariationKey + "$gen";
        BufferedImage result = this.imageCache.getCachedImageOrGenerate(generatedKey, this.lib.getTileSize(), false, riverVariationNumber, () -> {
            BufferedImage riverPebblesImage = riverPebblesImageResource.getImage(this.lib.getTileSize(), false);
            BufferedImage riverWaterImage = riverWaterImageResource.getVariation(riverVariationNumber).getImage(this.lib.getTileSize(), false);
            String riverMaskKey = "image.mask.river" + minorString + (String)(riverVariationKey.isEmpty() ? "" : "." + riverVariationKey);
            BufferedImage baseMaskImage = this.imageCache.getSizedImage(riverMaskKey, this.lib.getTileSize(), false);
            BufferedImage maskImage = this.createRiverMaskImageWithTransitions(baseMaskImage, minorToMajorTransitions);
            BufferedImage baseTileMask = this.lib.getTerrainMask(null);
            return RiverAnimationImageCreator.generateImage(riverPebblesImage, riverWaterImage, riverVariationNumber, maskImage, baseTileMask);
        });
        return result;
    }

    private static ImageResource getRiverPebblesImageResource() {
        String key = "image.tile.river.pebbles";
        return ImageCache.getImageResource("image.tile.river.pebbles");
    }

    private BufferedImage createRiverMaskImageWithTransitions(BufferedImage baseMaskImage, List<Direction> minorToMajorTransitions) {
        if (minorToMajorTransitions.isEmpty()) {
            return baseMaskImage;
        }
        BufferedImage resultImage = ImageUtils.createBufferedImage(baseMaskImage.getWidth(), baseMaskImage.getHeight());
        Graphics2D g2d = resultImage.createGraphics();
        g2d.drawImage((Image)baseMaskImage, 0, 0, null);
        for (Direction d : minorToMajorTransitions) {
            String riverMaskKey = "image.mask.river.to_major." + d.toString().toLowerCase();
            BufferedImage maskImage = this.imageCache.getSizedImage(riverMaskKey, this.lib.getTileSize(), false);
            g2d.drawImage((Image)maskImage, 0, 0, null);
        }
        g2d.dispose();
        return resultImage;
    }

    private List<Direction> determineMinorToMajorRiverTransitions(Tile tile, List<Direction> riverTransitions) {
        if (tile.getRiver().getMagnitude() > 1) {
            return List.of();
        }
        List<Direction> directionsWithRiverTransitions = riverTransitions.stream().filter(d -> {
            Tile neighbour = tile.getNeighbourOrNull((Direction)d);
            return neighbour != null && (neighbour.hasRiver() && neighbour.getRiver().getMagnitude() > 1 || tile.isLand() && !neighbour.isLand());
        }).collect(Collectors.toList());
        return directionsWithRiverTransitions;
    }

    private List<Direction> determineRiverCombinations(Tile tile) {
        List<Direction> directionsWithRiver = Direction.longSides.stream().filter(d -> {
            Tile neighbour = tile.getNeighbourOrNull((Direction)d);
            return neighbour != null && (neighbour.hasRiver() || tile.isLand() && !neighbour.isLand());
        }).collect(Collectors.toList());
        return directionsWithRiver;
    }

    private List<Direction> determineRiverTransitionsUsingStyle(Tile tile) {
        TileImprovement river = tile.getRiver();
        if (river == null) {
            return List.of();
        }
        return river.getConnections().entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(e -> (Direction)e.getKey()).collect(Collectors.toList());
    }

    private String directionsToString(List<Direction> directions) {
        return directions.stream().map(d -> d.toString().toLowerCase()).sorted().reduce((a, b) -> a + "_" + b).orElse("");
    }

    private static BufferedImage generateImage(BufferedImage pebblesImage, BufferedImage waterImage, int riverImageVariationNumber, BufferedImage riverMaskImage, BufferedImage tileMask) {
        int width = waterImage.getWidth();
        int height = waterImage.getHeight();
        if (pebblesImage.getWidth() != width || pebblesImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (riverMaskImage.getWidth() != width || riverMaskImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (tileMask.getWidth() != width || tileMask.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        BufferedImage maskedInputImage = ImageUtils.imageWithAlphaFromMask(waterImage, riverMaskImage);
        BufferedImage riverAndPebblesImage = ImageUtils.createBufferedImage(width, height);
        Graphics2D g2d = riverAndPebblesImage.createGraphics();
        g2d.drawImage((Image)pebblesImage, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.9f));
        g2d.drawImage((Image)maskedInputImage, 0, 0, null);
        g2d.dispose();
        BufferedImage largerRiverMaskImage = RiverAnimationImageCreator.toLargerMaskWithLessTransparency(riverMaskImage, width, height);
        BufferedImage resultImage = ImageUtils.imageWithAlphaFromMask(riverAndPebblesImage, largerRiverMaskImage);
        return ImageUtils.imageWithAlphaFromMask(resultImage, tileMask);
    }

    private static BufferedImage toLargerMaskWithLessTransparency(BufferedImage riverMaskImage, int origWidth, int origHeight) {
        int largerWidth = (int)((float)origWidth * 1.25f);
        int largerHeight = (int)((float)origHeight * 1.25f);
        BufferedImage expandedRiverMaskImage = ImageUtils.createBufferedImage(largerWidth, largerHeight);
        Graphics2D expandedRiverMaskImageG2d = expandedRiverMaskImage.createGraphics();
        expandedRiverMaskImageG2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        expandedRiverMaskImageG2d.drawImage(riverMaskImage, 0, 0, largerWidth, largerHeight, null);
        int x = (largerWidth - origWidth) / 2;
        int y = (largerHeight - origHeight) / 2;
        expandedRiverMaskImageG2d.drawImage(riverMaskImage, x, y, origWidth, origHeight, null);
        expandedRiverMaskImageG2d.dispose();
        return expandedRiverMaskImage.getSubimage(x, y, origWidth, origHeight);
    }
}

