/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.infonode.docking.View;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.IKeyStrokeProcessor;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.FreeplaneResourceAccessor;
import org.freeplane.core.ui.menubuilders.XmlEntryStructureBuilder;
import org.freeplane.core.ui.menubuilders.action.EntriesForAction;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.BuilderDestroyerPair;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;
import org.freeplane.core.ui.menubuilders.generic.SubtreeProcessor;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.ui.menubuilders.menu.MenuAcceleratorChangeListener;
import org.freeplane.core.ui.menubuilders.menu.MenuBuildProcessFactory;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;
import org.freeplane.view.swing.ui.DefaultMouseWheelListener;
import org.freeplane.view.swing.ui.DefaultNodeKeyListener;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;
import org.freeplane.view.swing.ui.DefaultNodeMouseWheelListener;
import org.freeplane.view.swing.ui.MapsMenuAction;
import org.freeplane.view.swing.ui.ModesMenuAction;

public class UserInputListenerFactory
implements IUserInputListenerFactory {
    public static final String NODE_POPUP = "/node_popup";
    private IMouseListener mapMouseListener;
    private MouseWheelListener mapMouseWheelListener;
    private JPopupMenu mapsPopupMenu;
    private FreeplaneMenuBar menuBar;
    private final Set<IMouseWheelEventHandler> mRegisteredMouseWheelEventHandler = new LinkedHashSet<IMouseWheelEventHandler>();
    private DragGestureListener nodeDragListener;
    private DropTargetListener nodeDropTargetListener;
    private DefaultNodeKeyListener nodeKeyListener;
    private IMouseListener nodeMotionListener;
    private IMouseListener nodeMouseMotionListener;
    private MouseWheelListener nodeMouseWheelListener;
    private JPopupMenu nodePopupMenu;
    private final Map<String, JComponent> toolBars;
    private final List<JComponent>[] toolbarLists;
    private final List<Map<String, BuilderDestroyerPair>> customBuilders;
    private final List<BuildPhaseListener> buildPhaseListeners;
    private Entry genericMenuStructure;
    private SubtreeProcessor subtreeBuilder;
    private final ModeController modeController;
    private static final IKeyStrokeProcessor DEFAULT_PROCESSOR = new IKeyStrokeProcessor(){

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e) {
            return ResourceController.getResourceController().getAcceleratorManager().processKeyBinding(ks, e);
        }
    };
    private final IKeyStrokeProcessor delegateProcessor = new IKeyStrokeProcessor(){

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e) {
            return UserInputListenerFactory.this.keyEventProcessor.processKeyBinding(ks, e);
        }
    };
    private IKeyStrokeProcessor keyEventProcessor;
    private final Map<Entry, Entry> mapMenuEntries = new IdentityHashMap<Entry, Entry>();

    public UserInputListenerFactory(ModeController modeController) {
        this.modeController = modeController;
        this.customBuilders = new ArrayList<Map<String, BuilderDestroyerPair>>(PhaseProcessor.Phase.values().length);
        this.keyEventProcessor = DEFAULT_PROCESSOR;
        this.buildPhaseListeners = new ArrayList<BuildPhaseListener>();
        for (PhaseProcessor.Phase phase : PhaseProcessor.Phase.values()) {
            this.customBuilders.add(new HashMap());
        }
        Controller controller = Controller.getCurrentController();
        ActionEnabler actionEnabler = new ActionEnabler(modeController);
        controller.getMapViewManager().addMapSelectionListener(actionEnabler);
        ResourceController.getResourceController().addPropertyChangeListener(actionEnabler);
        this.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "navigate_maps", new BuilderDestroyerPair(new EntryVisitor(){

            @Override
            public void visit(Entry target) {
                UserInputListenerFactory.this.createMapActions(target);
            }

            @Override
            public boolean shouldSkipChildren(Entry entry) {
                return true;
            }
        }, new ChildActionEntryRemover(modeController)));
        this.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "navigate_modes", new BuilderDestroyerPair(new EntryVisitor(){

            @Override
            public void visit(Entry target) {
                UserInputListenerFactory.this.createModeActions(target);
            }

            @Override
            public boolean shouldSkipChildren(Entry entry) {
                return true;
            }
        }, new ChildActionEntryRemover(modeController)));
        this.toolBars = new LinkedHashMap<String, JComponent>();
        this.toolbarLists = this.newListArray();
        for (int j = 0; j < 4; ++j) {
            this.toolbarLists[j] = new LinkedList<JComponent>();
        }
    }

    public <T> T getMenu(Class<T> clazz) {
        return null;
    }

    public void setKeyEventProcessor(IKeyStrokeProcessor keyEventProcessor) {
        this.keyEventProcessor = keyEventProcessor;
    }

    private List<JComponent>[] newListArray() {
        return new List[4];
    }

    @Override
    public void addToolBar(String name, int position, JComponent toolBar) {
        this.toolBars.put(name, toolBar);
        this.toolbarLists[position].add(toolBar);
    }

    @Override
    public void addMouseWheelEventHandler(IMouseWheelEventHandler handler) {
        this.mRegisteredMouseWheelEventHandler.add(handler);
    }

    @Override
    public IMouseListener getMapMouseListener() {
        if (this.mapMouseListener == null) {
            this.mapMouseListener = new DefaultMapMouseListener();
        }
        return this.mapMouseListener;
    }

    @Override
    public MouseWheelListener getMapMouseWheelListener() {
        if (this.mapMouseWheelListener == null) {
            this.mapMouseWheelListener = new DefaultMouseWheelListener();
        }
        return this.mapMouseWheelListener;
    }

    @Override
    public JPopupMenu getMapPopup() {
        return this.mapsPopupMenu;
    }

    @Override
    public FreeplaneMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new FreeplaneMenuBar(this.delegateProcessor);
        }
        return this.menuBar;
    }

    @Override
    public Set<IMouseWheelEventHandler> getMouseWheelEventHandlers() {
        return Collections.unmodifiableSet(this.mRegisteredMouseWheelEventHandler);
    }

    @Override
    public DragGestureListener getNodeDragListener() {
        return this.nodeDragListener;
    }

    @Override
    public DropTargetListener getNodeDropTargetListener() {
        return this.nodeDropTargetListener;
    }

    @Override
    public KeyListener getNodeKeyListener() {
        if (this.nodeKeyListener == null) {
            this.nodeKeyListener = new DefaultNodeKeyListener(null);
        }
        return this.nodeKeyListener;
    }

    @Override
    public InputMethodListener getNodeInputMethodListener() {
        if (this.nodeKeyListener == null) {
            this.nodeKeyListener = new DefaultNodeKeyListener(null);
        }
        return this.nodeKeyListener;
    }

    public IMouseListener getNodeMotionListener() {
        return this.nodeMotionListener;
    }

    @Override
    public IMouseListener getNodeMouseMotionListener() {
        if (this.nodeMouseMotionListener == null) {
            this.nodeMouseMotionListener = new DefaultNodeMouseMotionListener();
        }
        return this.nodeMouseMotionListener;
    }

    @Override
    public MouseWheelListener getNodeMouseWheelListener() {
        if (this.nodeMouseWheelListener == null) {
            this.nodeMouseWheelListener = new DefaultNodeMouseWheelListener(this.getMapMouseWheelListener());
        }
        return this.nodeMouseWheelListener;
    }

    @Override
    public JPopupMenu getNodePopupMenu() {
        return this.nodePopupMenu;
    }

    @Override
    public JComponent getToolBar(String name) {
        return this.toolBars.get(name);
    }

    @Override
    public Iterable<JComponent> getToolBars(int position) {
        return this.toolbarLists[position];
    }

    @Override
    public void removeMouseWheelEventHandler(IMouseWheelEventHandler handler) {
        this.mRegisteredMouseWheelEventHandler.remove(handler);
    }

    public void setMapMouseListener(IMouseListener mapMouseMotionListener) {
        if (this.mapMouseListener != null) {
            throw new RuntimeException("already set");
        }
        this.mapMouseListener = mapMouseMotionListener;
    }

    public void setMapMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (this.mapMouseWheelListener != null) {
            throw new RuntimeException("already set");
        }
        this.mapMouseWheelListener = mouseWheelListener;
    }

    public void setMenuBar(FreeplaneMenuBar menuBar) {
        if (this.mapMouseWheelListener != null) {
            throw new RuntimeException("already set");
        }
        this.menuBar = menuBar;
    }

    public void setNodeDragListener(DragGestureListener nodeDragListener) {
        if (this.nodeDragListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeDragListener = nodeDragListener;
    }

    public void setNodeDropTargetListener(DropTargetListener nodeDropTargetListener) {
        if (this.nodeDropTargetListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeDropTargetListener = nodeDropTargetListener;
    }

    public void setNodeKeyListener(DefaultNodeKeyListener nodeKeyListener) {
        if (this.nodeKeyListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeKeyListener = nodeKeyListener;
    }

    public void setNodeMotionListener(IMouseListener nodeMotionListener) {
        if (this.nodeMotionListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeMotionListener = nodeMotionListener;
    }

    public void setNodeMouseMotionListener(IMouseListener nodeMouseMotionListener) {
        if (this.nodeMouseMotionListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeMouseMotionListener = nodeMouseMotionListener;
    }

    public void setNodeMouseWheelListener(MouseWheelListener nodeMouseWheelListener) {
        if (this.nodeMouseWheelListener != null) {
            throw new RuntimeException("already set");
        }
        this.nodeMouseWheelListener = nodeMouseWheelListener;
    }

    public void setNodePopupMenu(JPopupMenu nodePopupMenu) {
        if (this.nodePopupMenu != null) {
            throw new RuntimeException("already set");
        }
        this.nodePopupMenu = nodePopupMenu;
    }

    @Override
    public void updateMapList() {
        for (Entry entry : this.mapMenuEntries.keySet()) {
            this.rebuildMenu(entry);
        }
    }

    private void createModeActions(Entry modesMenuEntry) {
        this.rebuildMenuOnMapChange(modesMenuEntry);
        Controller controller = Controller.getCurrentController();
        EntryAccessor entryAccessor = new EntryAccessor();
        for (String key : new LinkedList<String>(controller.getModes())) {
            ModesMenuAction modesMenuAction = new ModesMenuAction(key, controller);
            this.modeController.addActionIfNotAlreadySet(modesMenuAction);
            Entry actionEntry = new Entry();
            entryAccessor.setAction(actionEntry, modesMenuAction);
            actionEntry.setName(modesMenuAction.getKey());
            ModeController modeController = controller.getModeController();
            if (modeController != null && modeController.getModeName().equals(key)) {
                modesMenuAction.setSelected(true);
            }
            modesMenuEntry.addChild(actionEntry);
            ResourceController.getResourceController().getProperty("keystroke_mode_" + key);
        }
    }

    private void createMapActions(Entry mapsMenuEntry) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        ViewController viewController = Controller.getCurrentController().getViewController();
        List<? extends Component> mapViewVector = viewController.getMapViewVector();
        if (mapViewVector == null) {
            return;
        }
        ArrayList<? extends Component> sortedMapViewVector = new ArrayList<Component>(mapViewVector);
        Collections.sort(sortedMapViewVector, Comparator.comparing(c -> c.getName().toLowerCase()));
        EntryAccessor entryAccessor = new EntryAccessor();
        for (Component component : sortedMapViewVector) {
            String displayName = component.getName();
            Entry actionEntry = new Entry();
            View view = (View)SwingUtilities.getAncestorOfClass(View.class, component);
            String viewTitle = view.getTitle();
            boolean hasCustomTitle = !displayName.equals(viewTitle);
            String label = displayName + (hasCustomTitle ? " : '" + viewTitle + "'" : "");
            MapsMenuAction action = new MapsMenuAction(displayName, label);
            actionEntry.setName(action.getKey());
            this.modeController.addActionIfNotAlreadySet(action);
            entryAccessor.setAction(actionEntry, action);
            MapView currentMapView = (MapView)mapViewManager.getMapViewComponent();
            if (currentMapView != null && component == currentMapView) {
                action.setSelected(true);
            }
            mapsMenuEntry.addChild(actionEntry);
        }
    }

    private void rebuildMenuOnMapChange(Entry entry) {
        Entry menuEntry = entry.getParent();
        while (menuEntry.getName().isEmpty()) {
            menuEntry = menuEntry.getParent();
        }
        this.mapMenuEntries.put(menuEntry, null);
    }

    @Override
    public void rebuildMenu(Entry entry) {
        if (this.subtreeBuilder != null) {
            this.subtreeBuilder.rebuildChildren(entry);
        }
    }

    @Override
    public void rebuildMenus(String name) {
        if (this.genericMenuStructure != null) {
            List<Entry> entries = this.genericMenuStructure.findEntries(name);
            for (Entry entry : entries) {
                this.rebuildMenu(entry);
            }
        }
    }

    @Override
    public void updateMenus(String menuStructureResource, Set<String> plugins) {
        this.mapsPopupMenu = new JPopupMenu();
        this.mapsPopupMenu.setName(TextUtils.getText("mindmaps"));
        URL genericStructure = ResourceController.getResourceController().getResource(menuStructureResource);
        try {
            FreeplaneResourceAccessor resourceAccessor = new FreeplaneResourceAccessor();
            EntriesForAction entries = new EntriesForAction();
            ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();
            MenuBuildProcessFactory buildProcessFactory = new MenuBuildProcessFactory(this, this.modeController, resourceAccessor, acceleratorManager, entries, this.buildPhaseListeners);
            PhaseProcessor buildProcessor = buildProcessFactory.getBuildProcessor();
            this.subtreeBuilder = buildProcessFactory.getChildProcessor();
            acceleratorManager.addAcceleratorChangeListener(this.modeController, new MenuAcceleratorChangeListener(entries));
            for (PhaseProcessor.Phase phase : PhaseProcessor.Phase.values()) {
                for (Map.Entry<String, BuilderDestroyerPair> entry : this.customBuilders.get(phase.ordinal()).entrySet()) {
                    buildProcessor.phase(phase).addBuilderPair(entry.getKey(), entry.getValue());
                }
            }
            InputStream resource = genericStructure.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
            this.genericMenuStructure = XmlEntryStructureBuilder.buildMenuStructure(reader);
            this.filterPlugins(this.genericMenuStructure, plugins);
            buildProcessor.build(this.genericMenuStructure);
            if (Boolean.getBoolean("org.freeplane.outputUnusedActions")) {
                this.outputUnusedActions();
            }
        }
        catch (Exception e) {
            boolean isUserDefined = this.isUserDefined(genericStructure);
            if (isUserDefined) {
                LogUtils.warn(e);
                String myMessage = TextUtils.format("menu_error", genericStructure.getPath(), e.getMessage());
                UITools.backOtherWindows();
                JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), myMessage, "Freeplane", 0);
                System.exit(-1);
            }
            throw new RuntimeException("Error in menu resource " + menuStructureResource, e);
        }
    }

    private boolean isUserDefined(URL location) {
        try {
            if (location == null || !location.getProtocol().equalsIgnoreCase("file")) {
                return false;
            }
            String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
            if (freeplaneUserDirectory == null) {
                return false;
            }
            String userResourcesUrl = Compat.fileToUrl(new File(freeplaneUserDirectory, "resources")).getPath();
            return location.getPath().startsWith(userResourcesUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void filterPlugins(Entry entry, Set<String> plugins) {
        Iterator<Entry> iterator = entry.children().iterator();
        while (iterator.hasNext()) {
            Entry child = iterator.next();
            Object plugin = child.getAttribute("plugin");
            if (plugin != null && !plugins.contains(plugin)) {
                iterator.remove();
                continue;
            }
            this.filterPlugins(child, plugins);
        }
    }

    private void outputUnusedActions() {
        StringBuilder sb = new StringBuilder();
        sb.append("Unused actions for mode ").append(this.modeController.getModeName()).append('\n');
        TreeSet<String> actionKeys = new TreeSet<String>();
        actionKeys.addAll(this.modeController.getActionKeys());
        actionKeys.addAll(this.modeController.getController().getActionKeys());
        block0: for (String key : actionKeys) {
            List<Entry> entries = this.genericMenuStructure.findEntries(key);
            for (Entry entry : entries) {
                if (new EntryAccessor().getComponent(entry) == null) continue;
                continue block0;
            }
            sb.append(key).append('\n');
        }
        LogUtils.info(sb.toString());
    }

    @Override
    public void addUiBuilder(PhaseProcessor.Phase phase, String name, BuilderDestroyerPair builderDestroyerPair) {
        this.customBuilders.get(phase.ordinal()).put(name, builderDestroyerPair);
    }

    @Override
    public void addBuildPhaseListener(BuildPhaseListener listener) {
        this.buildPhaseListeners.add(listener);
    }

    @Override
    public Entry getGenericMenuStructure() {
        return this.genericMenuStructure;
    }

    private final class ActionEnabler
    implements IMapSelectionListener,
    IFreeplanePropertyListener {
        private final ModeController modeController;
        private UserRole userRole = null;

        private ActionEnabler(ModeController modeController) {
            this.modeController = modeController;
        }

        @Override
        public void afterMapChange(MapModel oldMap, MapModel newMap) {
            if (this.modeController.equals(Controller.getCurrentModeController())) {
                this.updateActions(newMap);
            }
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (ModeController.USER_INTERFACE_PROPERTIES.contains(propertyName)) {
                this.updateActions(this.modeController.getController().getMap());
            }
        }

        private void updateActions(MapModel map) {
            UserRole newUserRole = this.modeController.userRole(map);
            if (newUserRole != this.userRole) {
                this.userRole = newUserRole;
                RecursiveMenuStructureProcessor recursiveMenuStructureProcessor = new RecursiveMenuStructureProcessor();
                recursiveMenuStructureProcessor.setDefaultBuilder(new EntryVisitor(){
                    EntryAccessor entryAccessor = new EntryAccessor();

                    @Override
                    public void visit(Entry entry) {
                        AFreeplaneAction action = this.entryAccessor.getAction(entry);
                        if (action != null) {
                            action.afterMapChange(ActionEnabler.this.userRole);
                        }
                        entry.removeAttribute("allowed");
                        entry.setAttribute("allowed", (Object)entry.isAllowed(ActionEnabler.this.userRole));
                    }

                    @Override
                    public boolean shouldSkipChildren(Entry entry) {
                        return false;
                    }
                });
                recursiveMenuStructureProcessor.build(UserInputListenerFactory.this.genericMenuStructure);
            }
        }
    }
}

