/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.FileData;
import docking.widgets.tree.support.FileNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

class DirectoryNode
extends GTreeLazyNode
implements FileData {
    private final File file;

    DirectoryNode(File file) {
        this.file = file;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public List<GTreeNode> generateChildren() {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        File[] files = this.file.listFiles();
        if (files != null) {
            for (File directoryFile : files) {
                if (directoryFile.isDirectory()) {
                    children.add(new DirectoryNode(directoryFile));
                    continue;
                }
                children.add(new FileNode(directoryFile));
            }
        }
        Collections.sort(children);
        return children;
    }

    @Override
    public int compareTo(GTreeNode o) {
        if (!(o instanceof DirectoryNode)) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return null;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getToolTip() {
        return this.file.getAbsolutePath();
    }

    @Override
    public int hashCode() {
        return this.file.getAbsolutePath().hashCode();
    }
}

