/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.MachoExtractProgramBuilder;
import ghidra.app.util.opinion.MachoLoader;
import ghidra.file.formats.ios.fileset.MachoFileSetExtractor;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MachoFileSetExtractLoader
extends MachoLoader {
    public static final String MACHO_FILESET_EXTRACT_NAME = "Extracted Mach-O File Set Entry";

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        if (provider.length() >= (long)MachoFileSetExtractor.FOOTER_V1.length && Arrays.equals(MachoFileSetExtractor.FOOTER_V1, provider.readBytes(provider.length() - (long)MachoFileSetExtractor.FOOTER_V1.length, (long)MachoFileSetExtractor.FOOTER_V1.length))) {
            return super.findSupportedLoadSpecs(provider);
        }
        return List.of();
    }

    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)provider, (TaskMonitor)monitor);
            MachoExtractProgramBuilder.buildProgram(program, provider, fileBytes, false, log, monitor);
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        FSRL fsrl = provider.getFSRL();
        Group[] children = program.getListing().getDefaultRootModule().getChildren();
        if (Arrays.stream(children).anyMatch(e -> e.getName().contains(fsrl.getPath()))) {
            log.appendMsg("%s has already been added".formatted(fsrl.getPath()));
            return;
        }
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)provider, (TaskMonitor)monitor);
            MachoExtractProgramBuilder.buildProgram(program, provider, fileBytes, true, log, monitor);
        }
        catch (CancelledException e2) {
            return;
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new IOException(e4);
        }
    }

    public boolean supportsLoadIntoProgram(Program program) {
        return MACHO_FILESET_EXTRACT_NAME.equals(program.getExecutableFormat());
    }

    public String getName() {
        return MACHO_FILESET_EXTRACT_NAME;
    }

    public int getTierPriority() {
        return 49;
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return List.of();
    }

    protected boolean isLoadLibraries(List<Option> options) {
        return false;
    }

    protected boolean shouldSearchAllPaths(Program program, List<Option> options, MessageLog log) {
        return false;
    }

    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
    }
}

