/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.util;

import ghidra.file.formats.android.art.ArtStorageMode;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import utilities.util.FileUtilities;

public class Decompressor {
    public static byte[] decompress(ArtStorageMode mode, byte[] source, int maxDecompressedSize, TaskMonitor monitor) throws IOException {
        if (mode == ArtStorageMode.kStorageModeLZ4) {
            return Decompressor.decompressLZ4(source, maxDecompressedSize, monitor);
        }
        if (mode == ArtStorageMode.kStorageModeLZ4HC) {
            return Decompressor.decompressLZ4HC(source, maxDecompressedSize, monitor);
        }
        if (mode == ArtStorageMode.kStorageModeUncompressed) {
            return source;
        }
        throw new IOException("invalid storage mode");
    }

    private static byte[] decompressLZ4(byte[] source, int maxDecompressedSize, TaskMonitor monitor) throws IOException {
        try {
            ByteArrayOutputStream decompressedStream = new ByteArrayOutputStream();
            BlockLZ4CompressorInputStream compressedStream = new BlockLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(source));
            FileUtilities.copyStreamToStream((InputStream)compressedStream, (OutputStream)decompressedStream, (TaskMonitor)monitor);
            return decompressedStream.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static byte[] decompressLZ4HC(byte[] source, int maxDecompressedSize, TaskMonitor monitor) throws IOException {
        try {
            ByteArrayOutputStream decompressedStream = new ByteArrayOutputStream();
            BlockLZ4CompressorInputStream compressedStream = new BlockLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(source));
            FileUtilities.copyStreamToStream((InputStream)compressedStream, (OutputStream)decompressedStream, (TaskMonitor)monitor);
            return decompressedStream.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

