/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;

public class UDIFHeader {
    private int signature;
    private int version;
    private int headerSize;
    private int flags;
    private long runningDataForkOffset;
    private long dataForkOffset;
    private long dataForkLength;
    private long rsrcForkOffset;
    private long rsrcForkLength;
    private int segmentNumber;
    private int segmentCount;
    private byte[] segmentID;
    private int dataChecksumType;
    private int dataChecksumSize;
    private int[] dataChecksum;
    private long xmlOffset;
    private long xmlLength;
    private byte[] reserved;
    private int checksumType;
    private int checksumSize;
    private int[] checksum;
    private int imageVariant;
    private long sectorCount;
    private int reserved2;
    private int reserved3;
    private int reserved4;
    private static final int SIGNATURE_MAGIC_KOLY = 1802464377;
    private static final int SIZEOF_UDIF_HEADER = 512;

    public static UDIFHeader read(ByteProvider bp) throws IOException {
        return UDIFHeader.read(bp, bp.length() - 512L);
    }

    public static UDIFHeader read(ByteProvider bp, long offset) throws IOException {
        BinaryReader br = new BinaryReader(bp, false);
        br.setPointerIndex(offset);
        UDIFHeader udif = new UDIFHeader();
        udif.signature = br.readNextInt();
        udif.version = br.readNextInt();
        udif.headerSize = br.readNextInt();
        udif.flags = br.readNextInt();
        udif.runningDataForkOffset = br.readNextLong();
        udif.dataForkOffset = br.readNextLong();
        udif.dataForkLength = br.readNextLong();
        udif.rsrcForkOffset = br.readNextLong();
        udif.rsrcForkLength = br.readNextLong();
        udif.segmentNumber = br.readNextInt();
        udif.segmentCount = br.readNextInt();
        udif.segmentID = br.readNextByteArray(16);
        udif.dataChecksumType = br.readNextInt();
        udif.dataChecksumSize = br.readNextInt();
        udif.dataChecksum = br.readNextIntArray(32);
        udif.xmlOffset = br.readNextLong();
        udif.xmlLength = br.readNextLong();
        udif.reserved = br.readNextByteArray(120);
        udif.checksumType = br.readNextInt();
        udif.checksumSize = br.readNextInt();
        udif.checksum = br.readNextIntArray(32);
        udif.imageVariant = br.readNextInt();
        udif.sectorCount = br.readNextLong();
        udif.reserved2 = br.readNextInt();
        udif.reserved3 = br.readNextInt();
        udif.reserved4 = br.readNextInt();
        return udif;
    }

    public boolean isValid() {
        return this.signature == 1802464377 && this.headerSize == 512;
    }

    public boolean hasGoodOffsets(ByteProvider bp) throws IOException {
        return 0L <= this.dataForkOffset && this.dataForkOffset < bp.length() && this.dataForkLength > 0L && this.dataForkOffset + this.dataForkLength < bp.length() && 0L <= this.xmlOffset && this.xmlOffset < bp.length() && this.xmlLength > 0L && this.xmlOffset + this.xmlLength < bp.length();
    }
}

