/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedActionTrigger;
import ghidra.framework.options.WrappedOption;
import java.util.Objects;
import javax.swing.KeyStroke;

class WrappedKeyStroke
implements WrappedOption {
    private static final String KEY_CODE = "KeyCode";
    private static final String MODIFIERS = "Modifiers";
    private KeyStroke keyStroke;

    WrappedKeyStroke() {
    }

    WrappedKeyStroke(KeyStroke ks) {
        this.keyStroke = ks;
    }

    @Override
    public Object getObject() {
        return this.keyStroke;
    }

    @Override
    public void readState(SaveState saveState) {
        if (saveState.hasValue(KEY_CODE)) {
            int keyCode = saveState.getInt(KEY_CODE, 0);
            int modifiers = saveState.getInt(MODIFIERS, 0);
            this.keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        }
    }

    @Override
    public void writeState(SaveState saveState) {
        if (this.keyStroke == null) {
            return;
        }
        saveState.putInt(KEY_CODE, this.keyStroke.getKeyCode());
        saveState.putInt(MODIFIERS, this.keyStroke.getModifiers());
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.KEYSTROKE_TYPE;
    }

    public String toString() {
        return Objects.toString(this.keyStroke);
    }

    public WrappedActionTrigger toWrappedActionTrigger() {
        ActionTrigger trigger = null;
        if (this.keyStroke != null) {
            trigger = new ActionTrigger(this.keyStroke);
        }
        return new WrappedActionTrigger(trigger);
    }
}

