/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.modal;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jungrapht.visualization.control.modal.Modal;

public class ModeContainer {
    protected JComponent container;
    protected Supplier<JComponent> containerSupplier;
    protected Supplier<JButton> buttonSupplier;
    protected Modal.Mode[] modes;
    protected Set<Modal> modals;

    public static Builder builder() {
        return new Builder();
    }

    ModeContainer(Builder builder) {
        this(builder.containerSupplier, builder.buttonSupplier, builder.modes, builder.modals);
    }

    private ModeContainer(Supplier<JComponent> containerSupplier, Supplier<JButton> buttonSupplier, Modal.Mode[] modes, Set<Modal> modals) {
        this.containerSupplier = containerSupplier;
        this.buttonSupplier = buttonSupplier;
        this.modes = modes;
        this.modals = modals;
    }

    public JComponent getContainer() {
        return this.container;
    }

    public boolean addModal(Modal modal) {
        return this.modals.add(modal);
    }

    public boolean removeModal(Modal modal) {
        return this.modals.remove(modal);
    }

    protected final void buildUI() {
        this.container = this.containerSupplier.get();
        Stream.of(this.modes).forEach(m -> {
            JButton button = this.buttonSupplier.get();
            button.setText(m.name());
            this.container.add(button);
            button.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Modal.Mode mode = Modal.Mode.valueOf(e.getItem().toString());
                    this.modals.forEach(modal -> modal.setMode(mode));
                }
            });
        });
    }

    public static class Builder {
        protected Supplier<JComponent> containerSupplier;
        protected Supplier<JButton> buttonSupplier;
        protected Modal.Mode[] modes;
        protected Set<Modal> modals = new LinkedHashSet<Modal>();

        public Builder containerSupplier(Supplier<JComponent> containerSupplier) {
            this.containerSupplier = containerSupplier;
            return this;
        }

        public Builder buttonSupplier(Supplier<JButton> buttonSupplier) {
            this.buttonSupplier = buttonSupplier;
            return this;
        }

        public Builder modes(Modal.Mode ... modes) {
            this.modes = modes;
            return this;
        }

        public Builder modals(Modal ... modals) {
            this.modals = Stream.of(modals).collect(Collectors.toCollection(LinkedHashSet::new));
            return this;
        }

        public ModeContainer build() {
            return new ModeContainer(this);
        }
    }
}

