/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.framework.main.logviewer.model.Pair;
import ghidra.framework.main.logviewer.ui.FVTable;
import ghidra.framework.main.logviewer.ui.FVTableModel;
import ghidra.util.Msg;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ViewportUtility
implements Observer {
    private int savePosition;
    private JViewport viewport;
    private FVTable table;
    private ChunkReader reader;
    private ChunkModel model;
    private FVEventListener eventListener;

    public ViewportUtility(FVEventListener eventListener) {
        this.eventListener = eventListener;
        eventListener.addObserver(this);
    }

    public void setViewport(JViewport viewport) {
        this.viewport = viewport;
    }

    public void setTable(FVTable table) {
        this.table = table;
    }

    public void setReader(ChunkReader reader) {
        this.reader = reader;
    }

    public void setModel(ChunkModel model) {
        this.model = model;
    }

    public int getHeight() {
        return this.viewport.getHeight();
    }

    public int getViewportPositionAsRow() {
        return this.viewport.getViewPosition().y / this.table.getRowHeight();
    }

    public boolean isInViewport(int row) {
        int viewportRowStart = this.viewport.getViewPosition().y / this.table.getRowHeight();
        int viewportRowEnd = viewportRowStart + this.viewport.getHeight() / this.table.getRowHeight();
        return row >= viewportRowStart && row <= viewportRowEnd;
    }

    public void moveViewportToBottom() {
        Point bottomPoint = new Point(0, this.table.getRowCount() * this.table.getRowHeight() - this.viewport.getHeight());
        this.viewport.setViewPosition(bottomPoint);
        FVEvent updateViewportEvt = new FVEvent(FVEvent.EventType.VIEWPORT_UPDATE, null);
        this.eventListener.send(updateViewportEvt);
    }

    public void moveViewportToTop() {
        Point topPoint = new Point(0, 0);
        this.viewport.setViewPosition(topPoint);
        FVEvent updateViewportEvt = new FVEvent(FVEvent.EventType.VIEWPORT_UPDATE, null);
        this.eventListener.send(updateViewportEvt);
    }

    public int getNumRowsInViewport() {
        return this.viewport.getHeight() / this.table.getRowHeight();
    }

    public void scrollViewportTo(int row) {
        int offset = this.getViewportOffset(row);
        if (offset < 0) {
            this.moveViewportUp(-offset, false);
        } else if (offset > 0) {
            this.moveViewportDown(offset, false);
        }
    }

    public void moveViewportUp(int rows, boolean selection) {
        block9: {
            if (!this.isStateValid()) {
                return;
            }
            Point newViewportPos = new Point(0, (int)this.viewport.getViewPosition().getY() - this.table.getRowHeight() * rows);
            this.savePosition = newViewportPos.y;
            if (newViewportPos.y < 0) {
                try {
                    List<String> readLines = this.reader.readPreviousChunk();
                    if (readLines.size() > 0) {
                        ((FVTableModel)this.table.getModel()).addRowsToTop(readLines);
                        if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                            Chunk chunk = this.model.remove(this.model.getSize() - 1);
                            newViewportPos = new Point(0, newViewportPos.y + this.table.getRowHeight() * chunk.linesInChunk);
                            this.savePosition = newViewportPos.y;
                            ((FVTableModel)this.table.getModel()).removeRowsFromBottom(chunk.linesInChunk);
                        } else {
                            this.savePosition += this.table.getRowHeight() * readLines.size();
                        }
                        break block9;
                    }
                    this.moveViewportToTop();
                    if (selection) {
                        this.updateSelectionToViewportTop();
                    }
                    return;
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Error creating loading new chunk for viewport decrement", (Throwable)e);
                }
            }
        }
        this.setPosition(new Point(0, this.savePosition));
        if (selection) {
            this.updateSelectionToViewportTop();
        }
    }

    public void moveViewportDown(int rows, boolean selection) {
        block8: {
            if (!this.isStateValid()) {
                return;
            }
            Point newViewportPos = new Point(0, (int)this.viewport.getViewPosition().getY() + this.table.getRowHeight() * rows);
            int viewportBottom = newViewportPos.y + this.viewport.getHeight();
            this.savePosition = newViewportPos.y;
            if (viewportBottom >= this.table.getHeight()) {
                try {
                    List<String> readLines = this.reader.readNextChunk();
                    if (readLines.size() > 0) {
                        ((FVTableModel)this.table.getModel()).addRowsToBottom(readLines);
                        if (this.model.getSize() > this.model.MAX_VISIBLE_CHUNKS) {
                            Chunk chunk = this.model.remove(0);
                            newViewportPos = new Point(0, newViewportPos.y - this.table.getRowHeight() * chunk.linesInChunk);
                            this.savePosition = newViewportPos.y;
                            ((FVTableModel)this.table.getModel()).removeRowsFromTop(chunk.linesInChunk);
                        }
                        break block8;
                    }
                    this.moveViewportToBottom();
                    if (selection) {
                        this.updateSelectionToViewportBottom();
                    }
                    return;
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Error creating loading new chunk for viewport increment", (Throwable)e);
                }
            }
        }
        this.setPosition(new Point(0, this.savePosition));
        if (selection) {
            this.updateSelectionToViewportBottom();
        }
    }

    private void updateSelectionToViewportTop() {
        long filePosForTopRow;
        Pair filePos = this.model.getFilePositionForRow(this.getViewportPositionAsRow());
        if (filePos == null) {
            return;
        }
        this.model.selectedByteStart = filePosForTopRow = filePos.getStart();
        this.table.restoreSelection();
    }

    private void updateSelectionToViewportBottom() {
        long filePosForBottomRow;
        int bottomRow = this.getViewportPositionAsRow() + this.getNumRowsInViewport();
        Pair filePos = this.model.getFilePositionForRow(bottomRow);
        if (filePos == null) {
            return;
        }
        this.model.selectedByteEnd = filePosForBottomRow = filePos.getEnd();
        this.table.restoreSelection();
    }

    private void setPosition(Point position) {
        if (!this.isStateValid()) {
            return;
        }
        if (position.y < 0) {
            position = new Point(0, 0);
        }
        this.viewport.setViewPosition(position);
        FVEvent updateViewportEvt = new FVEvent(FVEvent.EventType.VIEWPORT_UPDATE, null);
        this.eventListener.send(updateViewportEvt);
    }

    private int getViewportOffset(int row) {
        if (!this.isStateValid()) {
            return 0;
        }
        int viewportRowStart = this.viewport.getViewPosition().y / this.table.getRowHeight();
        int viewportRowEnd = viewportRowStart + this.viewport.getHeight() / this.table.getRowHeight();
        if (row < viewportRowStart) {
            return row - viewportRowStart;
        }
        if (row > viewportRowEnd) {
            return row - viewportRowEnd;
        }
        return 0;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FVEventListener && arg instanceof FVEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.handleFVEvent((FVEvent)arg);
            } else {
                SwingUtilities.invokeLater(() -> this.handleFVEvent((FVEvent)arg));
            }
        }
    }

    private void handleFVEvent(FVEvent event) {
        switch (event.eventType) {
            case VIEWPORT_UP: {
                this.moveViewportUp((Integer)event.arg, false);
                break;
            }
            case VIEWPORT_DOWN: {
                this.moveViewportDown((Integer)event.arg, false);
                break;
            }
            case VIEWPORT_PAGE_UP: {
                this.moveViewportUp(this.getNumRowsInViewport(), (Boolean)event.arg);
                break;
            }
            case VIEWPORT_PAGE_DOWN: {
                this.moveViewportDown(this.getNumRowsInViewport(), (Boolean)event.arg);
                break;
            }
        }
    }

    private boolean isStateValid() {
        return this.model != null && this.reader != null && this.viewport != null;
    }
}

