/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.Tool;
import docking.WindowPosition;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.actions.KeyBindingUtils;
import docking.options.editor.FontEditor;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import generic.theme.ThemeManager;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.plugin.core.script.SaveDialog;
import ghidra.app.plugin.core.script.ScriptAction;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.HelpLocation;
import ghidra.util.MD5Utilities;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeStack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import resources.Icons;

public class GhidraScriptEditorComponentProvider
extends ComponentProvider {
    static final String EDITOR_COMPONENT_NAME = "EDITOR";
    private static final String FONT_ID = "font.plugin.scripts.text.editor";
    static final String CHANGE_DESTINATION_TITLE = "Where Would You Like to Store Your Changes?";
    static final String FILE_ON_DISK_CHANGED_TITLE = "File Changed on Disk";
    static final String FILE_ON_DISK_MISSING_TITLE = "File on Disk is Missing";
    static final String SAVE_CHANGES_AS_TEXT = "Save Changes As...";
    static final String OVERWRITE_CHANGES_TEXT = "Overwrite Changes on Disk";
    static final String KEEP_CHANGES_TEXT = "Keep Changes";
    static final String DISCARD_CHANGES_TEXT = "Discard Changes";
    private static final int MAX_UNDO_REDO_SIZE = 50;
    private GhidraScriptMgrPlugin plugin;
    private GhidraScriptComponentProvider provider;
    private String title;
    private ResourceFile scriptSourceFile;
    private String fileHash;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction runAction;
    private DockingAction undoAction;
    private DockingAction redoAction;
    private DockingAction fontAction;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private FixedSizeStack<UndoableEdit> undoStack = new FixedSizeStack(50);
    private FixedSizeStack<UndoableEdit> redoStack = new FixedSizeStack(50);

    GhidraScriptEditorComponentProvider(GhidraScriptMgrPlugin plugin, GhidraScriptComponentProvider provider, ResourceFile scriptSourceFile) throws IOException {
        super((Tool)plugin.getTool(), "Script Editor", plugin.getName());
        this.plugin = plugin;
        this.provider = provider;
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.setWindowGroup("Script Group");
        this.setIntraGroupPosition(WindowPosition.RIGHT);
        this.loadScript(scriptSourceFile);
        this.addToTool();
        this.setVisible(true);
        this.createActions();
    }

    private void loadScript(ResourceFile scriptFile) throws IOException {
        this.scriptSourceFile = scriptFile;
        File fileOnDisk = this.scriptSourceFile.getFile(false);
        if (fileOnDisk == null || !fileOnDisk.exists()) {
            return;
        }
        this.fileHash = MD5Utilities.getMD5Hash((File)fileOnDisk);
        this.title = this.scriptSourceFile.getName() + (GhidraScriptEditorComponentProvider.isReadOnly(this.scriptSourceFile) ? " (Read-Only) " : "");
        this.setTitle(this.title);
        String scriptSource = this.loadSciptFile();
        if (this.textArea == null) {
            this.textArea = new KeyMasterTextArea(scriptSource);
            this.scrollPane = new JScrollPane(this.textArea);
            this.scrollPane.setName("EDITOR_SCROLL_PANE");
            this.scrollPane.setPreferredSize(new Dimension(400, 400));
        } else {
            this.textArea.setText(scriptSource);
        }
    }

    private static boolean isReadOnly(ResourceFile scriptSourceFile) {
        return GhidraScriptUtil.isSystemScript(scriptSourceFile);
    }

    private void clearUndoRedoStack() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.updateUndoRedoAction();
    }

    private void updateUndoRedoAction() {
        this.undoAction.setEnabled(!this.undoStack.isEmpty());
        this.redoAction.setEnabled(!this.redoStack.isEmpty());
        this.updateChangedState();
    }

    private void undo() {
        UndoableEdit item = (UndoableEdit)this.undoStack.pop();
        this.redoStack.push((Object)item);
        item.undo();
        this.updateUndoRedoAction();
    }

    private void redo() {
        UndoableEdit item = (UndoableEdit)this.redoStack.pop();
        this.undoStack.push((Object)item);
        item.redo();
        this.updateUndoRedoAction();
    }

    boolean hasChanges() {
        return !this.undoStack.isEmpty() || this.isFileOnDiskMissing();
    }

    private void updateChangedState() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            this.setTitle("*" + this.title);
        } else {
            this.setTitle(this.title);
        }
        this.contextChanged();
    }

    private void clearChanges() {
        try {
            this.fileHash = MD5Utilities.getMD5Hash((File)this.scriptSourceFile.getFile(false));
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Script File Error", (Object)("Error accessing file: " + String.valueOf(this.scriptSourceFile)), (Throwable)e);
        }
        this.clearUndoRedoStack();
        this.updateChangedState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSciptFile() throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.scriptSourceFile.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
        }
        return buffer.toString();
    }

    private void createActions() {
        this.undoAction = new DockingAction("Undo", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.undo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == GhidraScriptEditorComponentProvider.this && !GhidraScriptEditorComponentProvider.this.undoStack.isEmpty();
            }
        };
        this.undoAction.setDescription("Undo");
        this.undoAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.undo"), "UndoRedo"));
        this.undoAction.setEnabled(false);
        this.undoAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(90, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.undoAction);
        this.redoAction = new DockingAction("Redo", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.redo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == GhidraScriptEditorComponentProvider.this && !GhidraScriptEditorComponentProvider.this.redoStack.isEmpty();
            }
        };
        this.redoAction.setDescription("Redo");
        this.redoAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.redo"), "UndoRedo"));
        this.redoAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(89, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        this.redoAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.redoAction);
        this.saveAction = new DockingAction("Save Script", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.save();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (contextObject != GhidraScriptEditorComponentProvider.this) {
                    return false;
                }
                if (GhidraScriptEditorComponentProvider.isReadOnly(GhidraScriptEditorComponentProvider.this.scriptSourceFile)) {
                    return false;
                }
                return GhidraScriptEditorComponentProvider.this.hasChanges();
            }
        };
        this.saveAction.setDescription("Save");
        this.saveAction.setToolBarData(new ToolBarData(Icons.SAVE_ICON, "Save"));
        this.saveAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(83, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.saveAction);
        DockingAction refreshAction = new DockingAction("Refresh Script", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.refresh();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == GhidraScriptEditorComponentProvider.this;
            }
        };
        refreshAction.setDescription("Refresh the contents of the editor from the file on disk");
        refreshAction.setToolBarData(new ToolBarData(Icons.REFRESH_ICON, "Refresh"));
        refreshAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)refreshAction);
        this.saveAsAction = new DockingAction("Save Script As", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.saveAs();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == GhidraScriptEditorComponentProvider.this;
            }
        };
        this.saveAsAction.setDescription("Save As...");
        this.saveAsAction.setToolBarData(new ToolBarData(Icons.SAVE_AS_ICON, "Save"));
        this.saveAsAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.saveAsAction);
        this.runAction = new DockingAction("Run Script", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (GhidraScriptEditorComponentProvider.this.hasChanges()) {
                    if (GhidraScriptEditorComponentProvider.isReadOnly(GhidraScriptEditorComponentProvider.this.scriptSourceFile)) {
                        Msg.showError(((Object)((Object)this)).getClass(), (Component)GhidraScriptEditorComponentProvider.this.getComponent(), (String)this.getName(), (Object)"Unable to run read-only script because there are unsaved changes.");
                        return;
                    }
                    int result = OptionDialog.showYesNoDialog((Component)GhidraScriptEditorComponentProvider.this.getComponent(), (String)this.getName(), (String)("File " + GhidraScriptEditorComponentProvider.this.scriptSourceFile.getName() + " has changed. Do you want to save it first?\n"));
                    if (result == 1) {
                        GhidraScriptEditorComponentProvider.this.save();
                    }
                }
                GhidraScriptEditorComponentProvider.this.provider.runScript(GhidraScriptEditorComponentProvider.this.scriptSourceFile);
            }
        };
        this.runAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.scriptmanager.run"), "ZRun"));
        this.runAction.setDescription("Run Editor's Script");
        this.runAction.setPopupMenuData(new MenuData(new String[]{"Run"}, "ZRun"));
        this.runAction.setEnabled(true);
        this.runAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Run"));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.runAction);
        this.fontAction = new DockingAction("Select Font", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptEditorComponentProvider.this.doSelectFont();
            }
        };
        this.fontAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.font"), "ZZFont"));
        this.fontAction.setDescription("Select Font");
        this.fontAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.fontAction);
        KeyBindingUtils.registerAction((JComponent)this.textArea, (DockingAction)this.saveAction, (ActionContextProvider)this);
        KeyBindingUtils.registerAction((JComponent)this.textArea, (DockingAction)this.redoAction, (ActionContextProvider)this);
        KeyBindingUtils.registerAction((JComponent)this.textArea, (DockingAction)this.undoAction, (ActionContextProvider)this);
    }

    private void refresh() {
        if (this.isFileOnDiskMissing()) {
            if (this.handleDeletedFile()) {
                this.provider.refresh();
            }
            return;
        }
        if (!this.hasFileOnDiskChanged()) {
            this.plugin.getTool().setStatusInfo("Refresh Script - file has not changed");
            return;
        }
        if (!this.hasChanges()) {
            this.reloadScript();
            return;
        }
        this.handleChangesOnDisk();
    }

    boolean isFileOnDiskMissing() {
        File fileOnDisk = this.scriptSourceFile.getFile(false);
        return !fileOnDisk.exists();
    }

    boolean hasFileOnDiskChanged() {
        File fileOnDisk = this.scriptSourceFile.getFile(false);
        if (fileOnDisk == null || !fileOnDisk.exists()) {
            return true;
        }
        try {
            String currentHash = MD5Utilities.getMD5Hash((File)fileOnDisk);
            return !this.fileHash.equals(currentHash);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Script File Error", (Object)("Error accessing file: " + String.valueOf(this.scriptSourceFile)), (Throwable)e);
            return false;
        }
    }

    private boolean handleDeletedFile() {
        int choice = OptionDialog.showOptionDialog((Component)this.scrollPane, (String)FILE_ON_DISK_MISSING_TITLE, (String)"The script file on disk no longer exists.\nWould you like to keep the changes in the editor or discard your changes?", (String)KEEP_CHANGES_TEXT, (String)DISCARD_CHANGES_TEXT, (int)3);
        if (choice == 0) {
            return false;
        }
        if (choice == 2) {
            this.closeComponentWithoutSaving();
            return true;
        }
        this.saveAs();
        return true;
    }

    private void handleChangesOnDisk() {
        int choice = OptionDialog.showOptionDialog((Component)this.scrollPane, (String)FILE_ON_DISK_CHANGED_TITLE, (String)("<html>The contents of the script file have changed on disk.<br><br>Would you like to <b>keep your changes</b> in the editor or <b><font color=\"" + GThemeDefaults.Colors.ERROR.toHexString() + "\">discard</font></b> your changes?"), (String)KEEP_CHANGES_TEXT, (String)DISCARD_CHANGES_TEXT, (int)3);
        if (choice == 0) {
            return;
        }
        if (choice == 2) {
            this.reloadScript();
            return;
        }
        choice = OptionDialog.showOptionDialog((Component)this.scrollPane, (String)CHANGE_DESTINATION_TITLE, (String)("<html>You can save your current changes to <b>another file</b> or <b><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">overwrite</font></b> the contents of the file on disk."), (String)SAVE_CHANGES_AS_TEXT, (String)OVERWRITE_CHANGES_TEXT, (int)3);
        if (choice == 0) {
            return;
        }
        ResourceFile previousFile = this.scriptSourceFile;
        if (choice == 1) {
            if (this.saveAs()) {
                this.provider.editScriptInGhidra(previousFile);
            }
            return;
        }
        this.doSave();
    }

    private void reloadScript() {
        try {
            this.loadScript(this.scriptSourceFile);
            this.fileHash = MD5Utilities.getMD5Hash((File)this.scriptSourceFile.getFile(false));
            this.clearChanges();
            this.refreshAction();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)("Error reloading script: " + String.valueOf(this.scriptSourceFile)), (Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void doSelectFont() {
        FontEditor editor = new FontEditor();
        editor.setValue((Object)Gui.getFont((String)FONT_ID));
        editor.showDialog();
        ThemeManager.getInstance().setFont(FONT_ID, (Font)editor.getValue());
    }

    private void save() {
        if (!this.hasChanges()) {
            return;
        }
        if (this.scriptSourceFile == null) {
            this.saveAs();
            return;
        }
        if (this.isFileOnDiskMissing()) {
            this.doSave();
            return;
        }
        if (this.hasFileOnDiskChanged()) {
            this.handleChangesOnDisk();
            return;
        }
        this.doSave();
    }

    private void doSave() {
        String text = this.textArea.getText();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(this.scriptSourceFile.getFile(false)));
            writer.print(text);
            writer.close();
            this.clearChanges();
            this.provider.getTable().repaint();
            this.refreshAction();
        }
        catch (IOException e) {
            if (this.scriptSourceFile.canWrite()) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error saving script", (Object)e.getMessage());
            }
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error saving script", (Object)"The file is not writable.");
        }
        this.provider.scriptUpdated(this.scriptSourceFile);
    }

    private void refreshAction() {
        ScriptAction action = this.provider.getActionManager().get(this.scriptSourceFile);
        if (action != null) {
            action.refresh();
        }
    }

    private boolean saveAs() {
        int result;
        HelpLocation help = new HelpLocation(this.plugin.getName(), this.saveAction.getName());
        SaveDialog dialog = new SaveDialog(this.getComponent(), "Save Script", this.provider, this.scriptSourceFile, GhidraScriptUtil.getProvider(this.scriptSourceFile), help);
        if (dialog.isCancelled()) {
            return false;
        }
        ResourceFile saveAsFile = dialog.getFile();
        boolean exists = saveAsFile.exists();
        if (exists && (result = OptionDialog.showYesNoDialog((Component)this.getComponent(), (String)this.getName(), (String)("Do you want to OVERWRITE the following script:\n" + saveAsFile.getName()))) != 1) {
            return false;
        }
        this.provider.enableScriptDirectory(saveAsFile.getParentFile());
        try {
            String str = this.textArea.getText();
            str = str.replaceAll(GhidraScriptUtil.getBaseName(this.scriptSourceFile), GhidraScriptUtil.getBaseName(saveAsFile));
            this.textArea.setText(str);
            PrintWriter writer = new PrintWriter(new FileWriter(saveAsFile.getFile(false)));
            writer.print(str);
            writer.close();
            this.provider.switchEditor(this.scriptSourceFile, saveAsFile);
            this.scriptSourceFile = saveAsFile;
            this.title = saveAsFile.getName();
            this.clearChanges();
            this.provider.sortScripts();
            return true;
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error saving as script", (Object)e.getMessage());
            return false;
        }
    }

    public void closeComponent() {
        if (this.isFileOnDiskMissing()) {
            if (!this.handleDeletedFile()) {
                return;
            }
            this.provider.refresh();
        }
        this.closeComponentSavingAsNecessary();
    }

    private void closeComponentSavingAsNecessary() {
        if (this.provider.removeScriptEditor(this.scriptSourceFile, true)) {
            super.closeComponent();
        }
    }

    private void closeComponentWithoutSaving() {
        if (this.provider.removeScriptEditor(this.scriptSourceFile, false)) {
            super.closeComponent();
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        return this.createContext((Object)this);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private class KeyMasterTextArea
    extends JTextArea {
        private KeyMasterTextArea(String text) {
            super(text);
            Gui.registerFont((Component)this, (String)GhidraScriptEditorComponentProvider.FONT_ID);
            this.setName(GhidraScriptEditorComponentProvider.EDITOR_COMPONENT_NAME);
            this.setWrapStyleWord(false);
            Document document = this.getDocument();
            document.addUndoableEditListener(e -> {
                UndoableEdit item = e.getEdit();
                GhidraScriptEditorComponentProvider.this.undoStack.push((Object)item);
                GhidraScriptEditorComponentProvider.this.redoStack.clear();
                GhidraScriptEditorComponentProvider.this.updateUndoRedoAction();
            });
            this.setCaretPosition(0);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            InputMap map = this.getInputMap(condition);
            ActionMap am = this.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    if (!action.isEnabled()) {
                        e.consume();
                        return true;
                    }
                    return SwingUtilities.notifyAction(action, ks, e, this, e.getModifiersEx());
                }
            }
            return false;
        }
    }
}

