/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryModule;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryReference;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.TableOfContents;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DynamicSymbolTableCommand
extends LoadCommand {
    private long ilocalsym;
    private long nlocalsym;
    private long iextdefsym;
    private long nextdefsym;
    private long iundefsym;
    private long nundefsym;
    private long tocoff;
    private long ntoc;
    private long modtaboff;
    private long nmodtab;
    private long extrefsymoff;
    private long nextrefsyms;
    private long indirectsymoff;
    private long nindirectsyms;
    private long extreloff;
    private long nextrel;
    private long locreloff;
    private long nlocrel;
    private List<TableOfContents> tocList = new ArrayList<TableOfContents>();
    private List<DynamicLibraryModule> moduleList = new ArrayList<DynamicLibraryModule>();
    private List<DynamicLibraryReference> referencedList = new ArrayList<DynamicLibraryReference>();
    private List<Integer> indirectSymbols = new ArrayList<Integer>();
    private List<RelocationInfo> externalRelocations = new ArrayList<RelocationInfo>();
    private List<RelocationInfo> localRelocations = new ArrayList<RelocationInfo>();

    DynamicSymbolTableCommand(BinaryReader loadCommandReader, BinaryReader dataReader, MachHeader header) throws IOException {
        super(loadCommandReader);
        long i;
        this.ilocalsym = loadCommandReader.readNextUnsignedInt();
        this.nlocalsym = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.iextdefsym = loadCommandReader.readNextUnsignedInt();
        this.nextdefsym = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.iundefsym = loadCommandReader.readNextUnsignedInt();
        this.nundefsym = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.tocoff = loadCommandReader.readNextUnsignedInt();
        this.ntoc = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.modtaboff = loadCommandReader.readNextUnsignedInt();
        this.nmodtab = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.extrefsymoff = loadCommandReader.readNextUnsignedInt();
        this.nextrefsyms = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.indirectsymoff = loadCommandReader.readNextUnsignedInt();
        this.nindirectsyms = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.extreloff = loadCommandReader.readNextUnsignedInt();
        this.nextrel = this.checkCount(loadCommandReader.readNextUnsignedInt());
        this.locreloff = loadCommandReader.readNextUnsignedInt();
        this.nlocrel = this.checkCount(loadCommandReader.readNextUnsignedInt());
        if (this.tocoff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.tocoff);
            for (i = 0L; i < this.ntoc; ++i) {
                this.tocList.add(new TableOfContents(dataReader));
            }
        }
        if (this.modtaboff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.modtaboff);
            for (i = 0L; i < this.nmodtab; ++i) {
                this.moduleList.add(new DynamicLibraryModule(dataReader, header));
            }
        }
        if (this.extrefsymoff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.extrefsymoff);
            for (i = 0L; i < this.nextrefsyms; ++i) {
                this.referencedList.add(new DynamicLibraryReference(dataReader));
            }
        }
        if (this.indirectsymoff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.indirectsymoff);
            for (i = 0L; i < this.nindirectsyms; ++i) {
                this.indirectSymbols.add(dataReader.readNextInt());
            }
        }
        if (this.extreloff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.extreloff);
            for (i = 0L; i < this.nextrel; ++i) {
                this.externalRelocations.add(new RelocationInfo(dataReader));
            }
        }
        if (this.locreloff > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.locreloff);
            for (i = 0L; i < this.nlocrel; ++i) {
                this.localRelocations.add(new RelocationInfo(dataReader));
            }
        }
    }

    public long getLocalSymbolIndex() {
        return this.ilocalsym;
    }

    public long getLocalSymbolCount() {
        return this.nlocalsym;
    }

    public long getExternalSymbolIndex() {
        return this.iextdefsym;
    }

    public long getExternalSymbolCount() {
        return this.nextdefsym;
    }

    public long getUndefinedSymbolIndex() {
        return this.iundefsym;
    }

    public long getUndefinedSymbolCount() {
        return this.nundefsym;
    }

    public long getTableOfContentsOffset() {
        return this.tocoff;
    }

    public long getTableOfContentsSize() {
        return this.ntoc;
    }

    public List<TableOfContents> getTableOfContentsList() {
        return this.tocList;
    }

    public long getModuleTableOffset() {
        return this.modtaboff;
    }

    public long getModuleTableSize() {
        return this.nmodtab;
    }

    public List<DynamicLibraryModule> getModuleList() {
        return this.moduleList;
    }

    public long getReferencedSymbolTableOffset() {
        return this.extrefsymoff;
    }

    public long getReferencedSymbolTableSize() {
        return this.nextrefsyms;
    }

    public List<DynamicLibraryReference> getReferencedSymbolList() {
        return this.referencedList;
    }

    public long getIndirectSymbolTableOffset() {
        return this.indirectsymoff;
    }

    public long getIndirectSymbolTableSize() {
        return this.nindirectsyms;
    }

    public List<Integer> getIndirectSymbols() {
        return this.indirectSymbols;
    }

    public long getExternalRelocationOffset() {
        return this.extreloff;
    }

    public long getExternalRelocationSize() {
        return this.nextrel;
    }

    public List<RelocationInfo> getExternalRelocations() {
        return this.externalRelocations;
    }

    public long getLocalRelocationOffset() {
        return this.locreloff;
    }

    public long getLocalRelocationSize() {
        return this.nlocrel;
    }

    public List<RelocationInfo> getLocalRelocations() {
        return this.localRelocations;
    }

    @Override
    public long getLinkerDataOffset() {
        return this.indirectsymoff;
    }

    @Override
    public long getLinkerDataSize() {
        return this.nindirectsyms * 4L;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "ilocalsym", null);
        struct.add(DWORD, "nlocalsym", null);
        struct.add(DWORD, "iextdefsym", null);
        struct.add(DWORD, "nextdefsym", null);
        struct.add(DWORD, "iundefsym", null);
        struct.add(DWORD, "nundefsym", null);
        struct.add(DWORD, "tocoff", null);
        struct.add(DWORD, "ntoc", null);
        struct.add(DWORD, "modtaboff", null);
        struct.add(DWORD, "nmodtab", null);
        struct.add(DWORD, "extrefsymoff", null);
        struct.add(DWORD, "nextrefsyms", null);
        struct.add(DWORD, "indirectsymoff", null);
        struct.add(DWORD, "nindirectsyms", null);
        struct.add(DWORD, "extreloff", null);
        struct.add(DWORD, "nextrel", null);
        struct.add(DWORD, "locreloff", null);
        struct.add(DWORD, "nlocrel", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "dysymtab_command";
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupIndirectSymbolTable(program, header, source, monitor, log);
    }

    private void markupIndirectSymbolTable(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address indirectSymbolTableAddr = this.fileOffsetToAddress(program, header, this.indirectsymoff, this.nindirectsyms);
        if (indirectSymbolTableAddr == null) {
            return;
        }
        this.markupPlateComment(program, indirectSymbolTableAddr, source, "indirect");
        Address symbolTableAddr = null;
        Address stringTableAddr = null;
        SymbolTableCommand symbolTable = header.getFirstLoadCommand(SymbolTableCommand.class);
        if (symbolTable != null) {
            symbolTableAddr = this.fileOffsetToAddress(program, header, symbolTable.getSymbolOffset(), symbolTable.getNumberOfSymbols());
            stringTableAddr = this.fileOffsetToAddress(program, header, symbolTable.getStringTableOffset(), symbolTable.getStringTableSize());
        }
        ReferenceManager referenceManager = program.getReferenceManager();
        try {
            int i = 0;
            while ((long)i < this.nindirectsyms) {
                NList nlist;
                int nlistIndex = this.indirectSymbols.get(i);
                Address dataAddr = indirectSymbolTableAddr.add((long)(i * DWORD.getLength()));
                DataUtilities.createData((Program)program, (Address)dataAddr, (DataType)DWORD, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                if (symbolTableAddr != null && (nlist = symbolTable.getSymbolAt(nlistIndex)) != null) {
                    Reference ref = referenceManager.addMemoryReference(dataAddr, symbolTableAddr.add((long)(nlistIndex * nlist.getSize())), RefType.DATA, SourceType.IMPORTED, 0);
                    referenceManager.setPrimary(ref, true);
                    if (stringTableAddr != null && nlist.getStringTableIndex() != 0) {
                        Address strAddr = stringTableAddr.add((long)nlist.getStringTableIndex());
                        referenceManager.addMemoryReference(dataAddr, strAddr, RefType.DATA, SourceType.IMPORTED, 0);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.appendMsg(DynamicSymbolTableCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, "indirect"));
        }
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            this.markupTOC(header, api, baseAddress, parentModule, monitor);
            this.markupModules(header, api, baseAddress, parentModule, monitor);
            this.markupReferencedSymbolTable(header, api, baseAddress, parentModule, monitor);
            this.makupIndirectSymbolTable(header, api, baseAddress, parentModule, monitor);
            this.markupExternalRelocations(api, baseAddress, parentModule, monitor);
            this.markupLocalRelocations(api, baseAddress, parentModule, monitor);
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
            log.appendException((Throwable)e);
        }
    }

    private void markupReferencedSymbolTable(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws DuplicateNameException, IOException, CodeUnitInsertionException, Exception {
        Address dyrefStartAddr;
        if (this.getReferencedSymbolTableSize() == 0L) {
            return;
        }
        int id = 0;
        Address dyrefAddr = dyrefStartAddr = baseAddress.getNewAddress(this.getReferencedSymbolTableOffset());
        int offset = 0;
        for (DynamicLibraryReference dyref : this.getReferencedSymbolList()) {
            if (monitor.isCancelled()) {
                return;
            }
            DataType dyrefDT = dyref.toDataType();
            api.createData(dyrefStartAddr.add((long)offset), dyrefDT);
            NList dyrefSym = header.getFirstLoadCommand(SymbolTableCommand.class).getSymbolAt(dyref.getSymbolIndex());
            DynamicLibraryModule module = this.findModuleContaining(id);
            api.setPlateComment(dyrefAddr, "0x" + Integer.toHexString(id) + " -- " + module.getModuleName() + "::" + dyrefSym.getString());
            offset += dyrefDT.getLength();
            ++id;
        }
        api.createFragment(parentModule, "REFERENCED_SYMBOLS", dyrefStartAddr, offset);
    }

    private DynamicLibraryModule findModuleContaining(int symbolIndex) {
        for (DynamicLibraryModule module : this.moduleList) {
            if (symbolIndex < module.getReferenceSymbolTableIndex() || symbolIndex >= module.getReferenceSymbolTableIndex() + module.getReferenceSymbolTableCount()) continue;
            return module;
        }
        throw new RuntimeException();
    }

    private void makupIndirectSymbolTable(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws Exception {
        int SIZEOF_DWORD = 4;
        if (this.getIndirectSymbolTableSize() == 0L) {
            return;
        }
        Address start = baseAddress.getNewAddress(this.getIndirectSymbolTableOffset());
        long length = this.getIndirectSymbolTableSize() * (long)SIZEOF_DWORD;
        api.createFragment(parentModule, "INDIRECT_SYMBOLS", start, length);
        for (int i = 0; i < this.indirectSymbols.size(); ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            Address addr = start.add((long)(i * SIZEOF_DWORD));
            NList symbol = header.getFirstLoadCommand(SymbolTableCommand.class).getSymbolAt(this.indirectSymbols.get(i));
            if (symbol == null) continue;
            api.setEOLComment(addr, symbol.getString());
        }
        api.createDwords(start, (int)this.getIndirectSymbolTableSize());
    }

    private void markupExternalRelocations(FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws Exception {
        if (this.getExternalRelocationSize() == 0L) {
            return;
        }
        Address relocStartAddr = baseAddress.getNewAddress(this.getExternalRelocationOffset());
        long offset = 0L;
        for (RelocationInfo reloc : this.externalRelocations) {
            if (monitor.isCancelled()) {
                return;
            }
            DataType relocDT = reloc.toDataType();
            Address relocAddr = relocStartAddr.add(offset);
            api.createData(relocAddr, relocDT);
            api.setPlateComment(relocAddr, reloc.toString());
            offset += (long)relocDT.getLength();
        }
        api.createFragment(parentModule, "EXTERNAL_RELOCATIONS", relocStartAddr, offset);
    }

    private void markupLocalRelocations(FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws Exception {
        if (this.getLocalRelocationSize() == 0L) {
            return;
        }
        Address relocStartAddr = baseAddress.getNewAddress(this.getLocalRelocationOffset());
        long offset = 0L;
        for (RelocationInfo reloc : this.localRelocations) {
            if (monitor.isCancelled()) {
                return;
            }
            Address relocAddr = relocStartAddr.add(offset);
            DataType relocDT = reloc.toDataType();
            api.createData(relocAddr, relocDT);
            api.setPlateComment(relocAddr, reloc.toString());
            offset += (long)relocDT.getLength();
        }
        api.createFragment(parentModule, "LOCAL_RELOCATIONS", relocStartAddr, offset);
    }

    private void markupModules(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws Exception {
        if (this.getModuleTableSize() == 0L) {
            return;
        }
        SymbolTableCommand symtabCommand = header.getFirstLoadCommand(SymbolTableCommand.class);
        Address moduleStartAddr = baseAddress.getNewAddress(this.getModuleTableOffset());
        long offset = 0L;
        int id = 0;
        for (DynamicLibraryModule module : this.moduleList) {
            if (monitor.isCancelled()) {
                return;
            }
            DataType moduleDT = module.toDataType();
            Address moduleAddr = moduleStartAddr.add(offset);
            Data moduleData = api.createData(moduleAddr, moduleDT);
            Address stringAddr = baseAddress.getNewAddress(symtabCommand.getStringTableOffset() + (long)module.getModuleNameIndex());
            api.createMemoryReference(moduleData, stringAddr, RefType.DATA);
            api.createAsciiString(stringAddr);
            api.setPlateComment(moduleAddr, "0x" + Integer.toHexString(id++) + " - " + module.getModuleName());
            offset += (long)moduleDT.getLength();
        }
        api.createFragment(parentModule, "MODULES", moduleStartAddr, offset);
    }

    private void markupTOC(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor) throws Exception {
        if (this.getTableOfContentsSize() == 0L) {
            return;
        }
        Address tocStartAddr = baseAddress.getNewAddress(this.getTableOfContentsOffset());
        long offset = 0L;
        for (TableOfContents toc : this.tocList) {
            if (monitor.isCancelled()) {
                return;
            }
            Address tocAddr = tocStartAddr.add(offset);
            api.setPlateComment(tocAddr, "Module: " + this.moduleList.get(toc.getModuleIndex()).getModuleName() + "\nSymbol: " + header.getFirstLoadCommand(SymbolTableCommand.class).getSymbolAt(toc.getSymbolIndex()).getString());
            DataType tocDT = toc.toDataType();
            api.createData(tocAddr, tocDT);
            offset += (long)tocDT.getLength();
        }
        api.createFragment(parentModule, "TOC", tocStartAddr, offset);
    }
}

