/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WEVTResourceDataType
extends DynamicDataType {
    private byte[] crimSig = new byte[]{67, 82, 73, 77};
    private byte[] wevtSig = new byte[]{87, 69, 86, 84};
    private byte[] keywSig = new byte[]{75, 69, 89, 87};
    private byte[] levlSig = new byte[]{76, 69, 86, 76};
    private byte[] mapsSig = new byte[]{77, 65, 80, 83};
    private byte[] chanSig = new byte[]{67, 72, 65, 78};
    private byte[] vmapSig = new byte[]{86, 77, 65, 80};
    private byte[] bmapSig = new byte[]{66, 77, 65, 80};
    private byte[] evntSig = new byte[]{69, 86, 78, 84};
    private byte[] opcoSig = new byte[]{79, 80, 67, 79};
    private byte[] taskSig = new byte[]{84, 65, 83, 75};
    private byte[] ttblSig = new byte[]{84, 84, 66, 76};
    private byte[] tempSig = new byte[]{84, 69, 77, 80};

    public WEVTResourceDataType() {
        this(null, "WEVTResource", null);
    }

    public WEVTResourceDataType(DataTypeManager dtm) {
        this(null, "WEVTResource", dtm);
    }

    protected WEVTResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public String getDescription() {
        return "WEVT (Windows Event Template) stored as a Resource";
    }

    public String getMnemonic(Settings settings) {
        return "WEVTRes";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return "WEVT";
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer mbIn) {
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        MemBuffer memBuffer = mbIn;
        int tempOffset = 0;
        ArrayList<Integer> eventOffsets = new ArrayList<Integer>();
        ArrayList<Integer> providerElementDescriptors = new ArrayList<Integer>();
        ArrayList<Integer> providerElementOffsets = new ArrayList<Integer>();
        int currentProviderElement = 0;
        if (this.checkMagic(this.crimSig, memBuffer, tempOffset)) {
            try {
                int numEventProviders = memBuffer.getInt(tempOffset + 12);
                tempOffset = this.addComp((DataType)this.createWEVTStructureHeader(), 16, "WEVT_Template Header", memBuffer.getAddress(), comps, tempOffset);
                StructureDataType epd = this.createEventProviderDescriptor(memBuffer, tempOffset, eventOffsets);
                if (epd == null) {
                    Msg.debug((Object)((Object)this), (Object)"Error applying Windows Event template (WEVT) resource data type.");
                    return null;
                }
                ArrayDataType EPDArray = new ArrayDataType((DataType)epd, numEventProviders, 20);
                tempOffset = this.addComp((DataType)EPDArray, 20 * numEventProviders, "Array of Event Provider Descriptors", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
                StructureDataType eventProvider = this.createEventProviderStructure(memBuffer, tempOffset, providerElementDescriptors, providerElementOffsets);
                tempOffset = this.addComp((DataType)eventProvider, eventProvider.getLength(), "Event Provider Structure", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
                for (int j = 0; j < providerElementDescriptors.size(); ++j) {
                    for (int i = 0; i < providerElementDescriptors.get(j); ++i) {
                        int lastUsedOffset = tempOffset;
                        if (lastUsedOffset < (tempOffset = providerElementOffsets.get(currentProviderElement).intValue())) {
                            int diff = tempOffset - lastUsedOffset;
                            ArrayDataType padding = new ArrayDataType((DataType)ByteDataType.dataType, diff, 1);
                            tempOffset = this.addComp((DataType)padding, diff, "padding", memBuffer.getAddress().add((long)lastUsedOffset), comps, lastUsedOffset);
                        }
                        byte[] bytes = new byte[4];
                        memBuffer.getBytes(bytes, tempOffset);
                        tempOffset = this.processProviderElement(bytes, memBuffer, tempOffset, comps);
                        if (tempOffset < 0) {
                            Msg.debug((Object)((Object)this), (Object)"Error processing Provider Element.");
                            return null;
                        }
                        ++currentProviderElement;
                    }
                }
            }
            catch (MemoryAccessException e1) {
                Msg.debug((Object)((Object)this), (Object)"Error applying Windows Event template (WEVT) resource data type.");
            }
        } else {
            Msg.debug((Object)((Object)this), (Object)"Not a valid Windows Event template (WEVT) resource data type");
            return null;
        }
        DataTypeComponent[] result = comps.toArray(new DataTypeComponent[comps.size()]);
        return result;
    }

    private StructureDataType createWEVTStructureHeader() {
        StructureDataType struct = new StructureDataType("WEVT_Header", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "");
        struct.add((DataType)UnsignedIntegerDataType.dataType, 4, "Size", "");
        struct.add((DataType)ShortDataType.dataType, 2, "MajorVersion", "");
        struct.add((DataType)ShortDataType.dataType, 2, "MinorVersion", "");
        struct.add((DataType)UnsignedIntegerDataType.dataType, 4, "Number of event providers", "");
        return struct;
    }

    private StructureDataType createEventProviderDescriptor(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> eventOffsets) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Event Provider Descriptor", 0);
        GuidDataType guidID = new GuidDataType();
        struct.add((DataType)guidID, 16, "Provider Identifier GUID", "");
        int offset = memBuffer.getInt(tempOffset + 16);
        Address offsetAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Provider Data Offset", "Provider Data Address: " + offsetAddr.toString());
        eventOffsets.add(memBuffer.getInt(tempOffset));
        return struct;
    }

    private StructureDataType createEventProviderStructure(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> providerElementDescriptors, ArrayList<Integer> providerElementOffsets) throws MemoryAccessException {
        if (!this.checkMagic(this.wevtSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid WEVT signature");
        }
        StructureDataType struct = new StructureDataType("Event Provider", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "WEVT");
        struct.add((DataType)UnsignedIntegerDataType.dataType, 4, "Size", "including the header");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "(-1 if not set)");
        struct.add((DataType)UnsignedIntegerDataType.dataType, 4, "Number of provider element descriptors", "");
        int currentPEDNumber = memBuffer.getInt(tempOffset += 12);
        providerElementDescriptors.add(currentPEDNumber);
        struct.add((DataType)UnsignedIntegerDataType.dataType, 4, "Number of Unknown 32-bit values", "");
        int numUnknownValues = memBuffer.getInt(tempOffset += 4);
        numUnknownValues *= 4;
        tempOffset += 4;
        for (int i = 0; i < currentPEDNumber; ++i) {
            struct.add((DataType)this.createProviderElementDescriptorStructure(memBuffer, tempOffset, providerElementOffsets), "Provider Element Descriptor", "");
            tempOffset += 8;
        }
        ArrayDataType unknown32bit = new ArrayDataType((DataType)DWordDataType.dataType, numUnknownValues / 4, 4);
        struct.add((DataType)unknown32bit, numUnknownValues, "Unknown 32-bit values", "");
        tempOffset += numUnknownValues;
        return struct;
    }

    private StructureDataType createProviderElementDescriptorStructure(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> providerElementOffsets) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Provider Element Descriptor", 0);
        int offset = memBuffer.getInt(tempOffset);
        Address provElementAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Provider element offset", "Provider Element Address: " + provElementAddr.toString());
        providerElementOffsets.add(memBuffer.getInt(tempOffset));
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        return struct;
    }

    private StructureDataType createKeywordStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        int keyworddefinitions = 0;
        ArrayList<Integer> keywordDataOffsets = new ArrayList<Integer>();
        if (!this.checkMagic(this.keywSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid KEYW signature");
        }
        StructureDataType struct = new StructureDataType("Keyword Definitions", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "KEYW");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of keyword definitions", "");
        keyworddefinitions = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (i = 0; i < keyworddefinitions; ++i) {
            struct.add((DataType)this.createKeywordDefStructure(memBuffer, tempOffset), "Keyword definitions", "");
            int dataOffset = memBuffer.getInt(tempOffset + 12);
            keywordDataOffsets.add(dataOffset);
            tempOffset += 16;
        }
        for (i = 0; i < keyworddefinitions; ++i) {
            tempOffset = (Integer)keywordDataOffsets.get(i);
            struct.add((DataType)this.createKeywordDataStructure(memBuffer, tempOffset), "Keyword data", "");
        }
        return struct;
    }

    private StructureDataType createKeywordDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Keyword definitions", 0);
        struct.add((DataType)QWordDataType.dataType, 8, "Identifier", "(Bitmask)");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        int dataOffset = memBuffer.getInt(tempOffset += 12);
        Address dataOffsetAddress = memBuffer.getAddress().add((long)dataOffset);
        struct.add((DataType)DWordDataType.dataType, 4, "Data offset", "Data offset address: " + dataOffsetAddress.toString());
        tempOffset += 4;
        return struct;
    }

    private StructureDataType createKeywordDataStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Keyword data", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "keyword data", "");
        tempOffset += size;
        return struct;
    }

    private StructureDataType createLevelStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        ArrayList<Integer> leveloffsets = new ArrayList<Integer>();
        int leveldefinitions = 0;
        if (!this.checkMagic(this.levlSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid LEVL signature");
        }
        StructureDataType struct = new StructureDataType("Level Definitions", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "LEVL");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "includes size of the header, 0 if empty");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of level definitions", "");
        leveldefinitions = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (i = 0; i < leveldefinitions; ++i) {
            struct.add((DataType)this.createLevelDefStructure(memBuffer, tempOffset), "Level Definition Structure", "");
            leveloffsets.add(memBuffer.getInt(tempOffset + 8));
            tempOffset += 12;
        }
        for (i = 0; i < leveldefinitions; ++i) {
            int levelDataSize = memBuffer.getInt(tempOffset);
            int offset = (Integer)leveloffsets.get(i);
            struct.add((DataType)this.createLevelDataStructure(memBuffer, offset), "Level Data Structure", "");
            tempOffset += levelDataSize;
        }
        return struct;
    }

    private StructureDataType createLevelDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Level Definition", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Identifier", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        int offset = memBuffer.getInt(tempOffset += 8);
        Address levelDataAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Data offset", "Level Data Address: " + levelDataAddr.toString());
        tempOffset += 4;
        return struct;
    }

    private StructureDataType createLevelDataStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Level Data", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "data", "");
        tempOffset += size;
        return struct;
    }

    private StructureDataType createMapsDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        int numMapDefs = 0;
        ArrayList<Integer> mapsDefsOffsets = new ArrayList<Integer>();
        ArrayList<Integer> mapStringDataOffsets = new ArrayList<Integer>();
        if (!this.checkMagic(this.mapsSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid MAPS signature");
        }
        StructureDataType struct = new StructureDataType("Maps Definitions", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "MAPS");
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Number of map definitions", "");
        numMapDefs = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (i = 0; i < numMapDefs; ++i) {
            int offset = memBuffer.getInt(tempOffset);
            Address offsetAddr = memBuffer.getAddress().add((long)offset);
            struct.add((DataType)DWordDataType.dataType, 4, "Map definition offset", "Offset Address: " + offsetAddr.toString());
            mapsDefsOffsets.add(offset);
            tempOffset += 4;
        }
        for (i = 0; i < numMapDefs; ++i) {
            tempOffset = (Integer)mapsDefsOffsets.get(i);
            if (this.checkMagic(this.vmapSig, memBuffer, tempOffset)) {
                struct.add((DataType)this.createValueMapDefStructure(memBuffer, tempOffset, mapStringDataOffsets));
                continue;
            }
            if (this.checkMagic(this.bmapSig, memBuffer, tempOffset)) {
                struct.add((DataType)this.createBMapDefStructure(memBuffer, tempOffset));
                continue;
            }
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid VMAP or BMAP signature");
        }
        for (i = 0; i < mapStringDataOffsets.size(); ++i) {
            tempOffset = (Integer)mapStringDataOffsets.get(i);
            struct.add((DataType)this.createMapStringStructure(memBuffer, tempOffset));
        }
        return struct;
    }

    private StructureDataType createValueMapDefStructure(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> mapStringDataOffsets) throws MemoryAccessException {
        int numVMAPEntries = 0;
        StructureDataType struct = new StructureDataType("Value Map Definition", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "VMAP");
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Map string data offset", "");
        mapStringDataOffsets.add(memBuffer.getInt(tempOffset += 8));
        tempOffset += 4;
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "Unknown");
        struct.add((DataType)DWordDataType.dataType, 4, "Number of value map entries", "");
        numVMAPEntries = memBuffer.getInt(tempOffset += 4);
        tempOffset += 4;
        for (int i = 0; i < numVMAPEntries; ++i) {
            struct.add((DataType)this.createValueMapEntryStructure(memBuffer, tempOffset), 8, "Value map entry", "");
        }
        return struct;
    }

    private StructureDataType createBMapDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("BMAP Map Definition", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "BMAP");
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset += 4);
        tempOffset += 4;
        ArrayDataType unknown = new ArrayDataType((DataType)ByteDataType.dataType, size - 8, 1);
        struct.add(unknown.getDataType(), size - 8, "Rest of BMAP structure", "Unknown format");
        tempOffset += size - 8;
        return struct;
    }

    private StructureDataType createValueMapEntryStructure(MemBuffer memBuffer, int tempOffset) {
        StructureDataType struct = new StructureDataType("Value Map Entry", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Identifier", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        tempOffset += 8;
        return struct;
    }

    private StructureDataType createMapStringStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Map String", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "Map String", "");
        tempOffset += size;
        return struct;
    }

    private StructureDataType createChannelStruct(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        ArrayList<Integer> channelDataOffsets = new ArrayList<Integer>();
        if (!this.checkMagic(this.chanSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid CHAN signature");
        }
        StructureDataType struct = new StructureDataType("Channel Definition Structure", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "CHAN");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of channel definitions", "");
        int channeldefs = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (i = 0; i < channeldefs; ++i) {
            struct.add((DataType)this.createChannelDefStructure(memBuffer, tempOffset, channelDataOffsets), 16, "Channel Definition", "");
            tempOffset += 16;
        }
        for (i = 0; i < channelDataOffsets.size(); ++i) {
            if (tempOffset < channelDataOffsets.get(i)) {
                int diff = channelDataOffsets.get(i) - tempOffset;
                ArrayDataType padding = new ArrayDataType((DataType)ByteDataType.dataType, diff, 1);
                struct.add(padding.getDataType(), diff, "Padding", "");
                tempOffset = channelDataOffsets.get(i);
            }
            int channelDataSize = memBuffer.getInt(tempOffset);
            struct.add((DataType)this.createChannelDataStructure(memBuffer, tempOffset), channelDataSize, "Channel Data", "");
            tempOffset += channelDataSize;
        }
        return struct;
    }

    private StructureDataType createChannelDefStructure(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> channelDataOffsets) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Channel Definition", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Identifier", "");
        int offset = memBuffer.getInt(tempOffset += 4);
        Address channelDataAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Data Offset", "Channel Data Address: " + channelDataAddr.toString());
        channelDataOffsets.add(memBuffer.getInt(tempOffset));
        tempOffset += 4;
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        tempOffset += 8;
        return struct;
    }

    private StructureDataType createChannelDataStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Channel Data", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "Channel Data String", "");
        return struct;
    }

    private StructureDataType createEventDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        ArrayList<Integer> unknownDwordsOffsetList = new ArrayList<Integer>();
        ArrayList<Integer> numUnknownDwordsList = new ArrayList<Integer>();
        if (!this.checkMagic(this.evntSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid EVNT signature");
        }
        StructureDataType struct = new StructureDataType("Event Definitions Structure", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "EVNT");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of event definitions", "");
        int eventdefs = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        tempOffset += 4;
        for (i = 0; i < eventdefs; ++i) {
            struct.add((DataType)this.createEventDefinitionStructure(memBuffer, tempOffset, unknownDwordsOffsetList, numUnknownDwordsList), "Event Definition", "");
            tempOffset += 48;
        }
        for (i = 0; i < eventdefs; ++i) {
            if (numUnknownDwordsList.get(i) <= 0) continue;
            tempOffset = unknownDwordsOffsetList.get(i);
            for (int j = 0; j < numUnknownDwordsList.get(i); ++j) {
                struct.add((DataType)DWordDataType.dataType, 4, "Unknown Dword # " + i, "");
                tempOffset += 4;
            }
        }
        return struct;
    }

    private StructureDataType createEventDefinitionStructure(MemBuffer memBuffer, int tempOffset, ArrayList<Integer> unknownDwordsOffsetList, ArrayList<Integer> numUnknownDwordsList) throws MemoryAccessException {
        String offsetString = new String();
        StructureDataType struct = new StructureDataType("Event Definitions", 0);
        struct.add((DataType)WordDataType.dataType, 2, "Identifier", "");
        tempOffset += 2;
        ArrayDataType eventDef = new ArrayDataType((DataType)ByteDataType.dataType, 6, 1);
        struct.add((DataType)eventDef, 6, "Unknown Format", "");
        tempOffset += 6;
        ArrayDataType keywords = new ArrayDataType((DataType)ByteDataType.dataType, 8, 1);
        struct.add((DataType)keywords, 8, "Keywords", "");
        tempOffset += 8;
        struct.add((DataType)DWordDataType.dataType, 4, "Message Identifier", "");
        int templateDefOffset = memBuffer.getInt(tempOffset += 4);
        offsetString = this.getOffsetAddressString(templateDefOffset, memBuffer);
        struct.add((DataType)DWordDataType.dataType, 4, "Template Definition Offset", offsetString);
        int opCodeDefOffset = memBuffer.getInt(tempOffset += 4);
        offsetString = this.getOffsetAddressString(opCodeDefOffset, memBuffer);
        struct.add((DataType)DWordDataType.dataType, 4, "Opcode Definition Offset", offsetString);
        int levelDefOffset = memBuffer.getInt(tempOffset += 4);
        offsetString = this.getOffsetAddressString(levelDefOffset, memBuffer);
        struct.add((DataType)DWordDataType.dataType, 4, "Level Definition Offset", offsetString);
        int taskDefOffset = memBuffer.getInt(tempOffset += 4);
        offsetString = this.getOffsetAddressString(taskDefOffset, memBuffer);
        struct.add((DataType)DWordDataType.dataType, 4, "Task Definition Offset", offsetString);
        int numDwordsInLastSection = memBuffer.getInt(tempOffset += 4);
        numUnknownDwordsList.add(numDwordsInLastSection);
        struct.add((DataType)DWordDataType.dataType, 4, "Number of Dwords in Next Section", "");
        int lastEventSectionOffset = memBuffer.getInt(tempOffset += 4);
        offsetString = this.getOffsetAddressString(lastEventSectionOffset, memBuffer);
        unknownDwordsOffsetList.add(lastEventSectionOffset);
        struct.add((DataType)DWordDataType.dataType, 4, "Offset to Dwords in Next Section", offsetString);
        tempOffset += 4;
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown (Flags)", "");
        tempOffset += 4;
        return struct;
    }

    private String getOffsetAddressString(int offset, MemBuffer memBuffer) {
        String offsetString = new String();
        if (offset > 0) {
            Address offsetAddr = memBuffer.getAddress().add((long)offset);
            offsetString = offsetString.concat("Address: " + offsetAddr.toString());
        } else {
            offsetString = "No offset";
        }
        return offsetString;
    }

    private StructureDataType createOpcodeStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        if (!this.checkMagic(this.opcoSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid OPCO signature");
        }
        StructureDataType struct = new StructureDataType("Opcode Definition Structure", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "OPCO");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "includes the header, empty if 0");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of opcode definitions", "");
        int opcodedefs = memBuffer.getInt(tempOffset += 8);
        int[] opcodeDataOffsets = new int[opcodedefs];
        tempOffset += 4;
        for (i = 0; i < opcodedefs; ++i) {
            opcodeDataOffsets[i] = memBuffer.getInt(tempOffset + 8);
            struct.add((DataType)this.createOpcodeDefStructure(memBuffer, tempOffset), 12, "Opcode Definition", "");
            tempOffset += 12;
        }
        for (i = 0; i < opcodedefs; ++i) {
            tempOffset = opcodeDataOffsets[i];
            struct.add((DataType)this.createOpcodeDataStructure(memBuffer, tempOffset), "Opcode Data", "");
        }
        return struct;
    }

    private StructureDataType createOpcodeDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Opcode Definition", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Identifier", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        int offset = memBuffer.getInt(tempOffset += 8);
        Address opcodeDataAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Data offset", "Data Opcode Address: " + opcodeDataAddr.toString());
        tempOffset += 4;
        return struct;
    }

    private StructureDataType createOpcodeDataStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Opcode Data", 0);
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "Including the size itself");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "Opcode Data String", "");
        tempOffset += size;
        return struct;
    }

    private StructureDataType createTaskStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        int i;
        ArrayList<Integer> taskDataOffsets = new ArrayList<Integer>();
        if (!this.checkMagic(this.taskSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid TASK signature");
        }
        StructureDataType struct = new StructureDataType("Task Definition Structure", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "TASK");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of task definitions", "");
        int taskdefs = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (i = 0; i < taskdefs; ++i) {
            ArrayDataType taskdefinitions = new ArrayDataType((DataType)this.createTaskDefStructure(memBuffer, tempOffset), taskdefs, 28);
            struct.add(taskdefinitions.getDataType(), 28, "Task Definition", "");
            int dataOffset = memBuffer.getInt(tempOffset + 24);
            taskDataOffsets.add(dataOffset);
            tempOffset += 28;
        }
        for (i = 0; i < taskdefs; ++i) {
            tempOffset = (Integer)taskDataOffsets.get(i);
            struct.add((DataType)this.createTaskDataStructure(memBuffer, tempOffset), "Task Data Structure", "");
        }
        return struct;
    }

    private StructureDataType createTaskDefStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Task definition", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Identifier", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Message-table identifier", "");
        GuidDataType guidID = new GuidDataType();
        struct.add((DataType)guidID, 16, "MUI Identifier GUID", "");
        int dataOffset = memBuffer.getInt(tempOffset += 24);
        Address dataOffsetAddr = memBuffer.getAddress().add((long)dataOffset);
        struct.add((DataType)DWordDataType.dataType, 4, "Data offset", "Data offset address: " + dataOffsetAddr.toString());
        tempOffset += 4;
        return struct;
    }

    private StructureDataType createTaskDataStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Task Data", 0);
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "Task Data", "");
        tempOffset += size;
        return struct;
    }

    private StructureDataType createTemplateTableStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        if (!this.checkMagic(this.ttblSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid TTBL signature");
        }
        StructureDataType struct = new StructureDataType("Template Table", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "TTBL");
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "Including template table header");
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of templates", "");
        int templates = memBuffer.getInt(tempOffset += 8);
        tempOffset += 4;
        for (int i = 0; i < templates; ++i) {
            int tempDefSize = memBuffer.getInt(tempOffset + 4);
            struct.add((DataType)this.createTemplateDefStructure(memBuffer, tempOffset, tempDefSize));
            tempOffset += tempDefSize;
        }
        return struct;
    }

    private StructureDataType createTemplateDefStructure(MemBuffer memBuffer, int tempOffset, int tempDefSize) throws MemoryAccessException {
        int i;
        if (!this.checkMagic(this.tempSig, memBuffer, tempOffset)) {
            throw new AssertException("Error applying WEVT Resource Data Type - Invalid TEMP signature");
        }
        StructureDataType struct = new StructureDataType("Template Definition", 0);
        struct.add((DataType)StringDataType.dataType, 4, "Signature", "TEMP");
        tempOffset += 4;
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "Including the template header");
        int numVariableDescriptors = memBuffer.getInt(tempOffset += 4);
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of variable descriptors", "");
        int numVariableNames = memBuffer.getInt(tempOffset += 4);
        struct.add((DataType)IntegerDataType.dataType, 4, "Number of variable names", "");
        int instanceVariablesOffset = memBuffer.getInt(tempOffset += 4);
        struct.add((DataType)DWordDataType.dataType, 4, "Instance variables offset", "address = " + memBuffer.getAddress().add((long)instanceVariablesOffset).toString());
        tempOffset += 4;
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown (# BinXML fragments?)", "");
        tempOffset += 4;
        GuidDataType guidID = new GuidDataType();
        struct.add((DataType)guidID, 16, "Identifier GUID", "");
        int bxmlLen = instanceVariablesOffset - (tempOffset += 16);
        ArrayDataType binaryXMLArray = new ArrayDataType((DataType)ByteDataType.dataType, bxmlLen, 1);
        struct.add(binaryXMLArray.getDataType(), bxmlLen, "Binary XML", "");
        tempOffset += bxmlLen;
        tempOffset = instanceVariablesOffset;
        ArrayList<Integer> instanceNamesOffsetList = new ArrayList<Integer>();
        for (i = 0; i < numVariableDescriptors; ++i) {
            struct.add((DataType)this.createTemplateInstanceVariableDescriptorStructure(memBuffer, tempOffset), 20, "", "");
            int namesOffset = memBuffer.getInt(tempOffset + 16);
            instanceNamesOffsetList.add(namesOffset);
            tempOffset += 20;
        }
        for (i = 0; i < numVariableNames; ++i) {
            tempOffset = (Integer)instanceNamesOffsetList.get(i);
            struct.add((DataType)this.createTemplateInstanceVariableNameStructure(memBuffer, tempOffset));
        }
        return struct;
    }

    private StructureDataType createTemplateInstanceVariableDescriptorStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Template Instance Variable Descriptor", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        struct.add((DataType)ByteDataType.dataType, 1, "Value type", "");
        struct.add((DataType)ByteDataType.dataType, 1, "Unknown", "");
        struct.add((DataType)WordDataType.dataType, 2, "Unknown", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        struct.add((DataType)DWordDataType.dataType, 4, "Unknown", "");
        int offset = memBuffer.getInt(tempOffset += 16);
        Address namesOffsetAddr = memBuffer.getAddress().add((long)offset);
        struct.add((DataType)DWordDataType.dataType, 4, "Template instance variable name offset", "Address Offset: " + namesOffsetAddr.toString());
        tempOffset += 4;
        return struct;
    }

    private StructureDataType createTemplateInstanceVariableNameStructure(MemBuffer memBuffer, int tempOffset) throws MemoryAccessException {
        StructureDataType struct = new StructureDataType("Template Instance Variable Name", 0);
        struct.add((DataType)IntegerDataType.dataType, 4, "Size", "");
        int size = memBuffer.getInt(tempOffset);
        struct.add((DataType)UnicodeDataType.dataType, size - 4, "Name String", "");
        return struct;
    }

    private boolean checkMagic(byte[] sigBytes, MemBuffer memBuffer, int tempOffset) {
        try {
            for (int i = 0; i < sigBytes.length; ++i) {
                if (sigBytes[i] == memBuffer.getByte(tempOffset + i)) continue;
                return false;
            }
        }
        catch (MemoryAccessException e) {
            Msg.debug((Object)((Object)this), (Object)"Incorrect signature for a WEVT resource");
        }
        return true;
    }

    private int processProviderElement(byte[] sigBytes, MemBuffer memBuffer, int tempOffset, List<DataTypeComponent> comps) throws MemoryAccessException {
        int newOffset = -1;
        if (Arrays.equals(sigBytes, this.keywSig)) {
            StructureDataType struct = this.createKeywordStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Keyword Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.levlSig)) {
            StructureDataType struct = this.createLevelStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Level Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.mapsSig)) {
            StructureDataType struct = this.createMapsDefStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Maps Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.chanSig)) {
            StructureDataType struct = this.createChannelStruct(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Channel Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.evntSig)) {
            StructureDataType struct = this.createEventDefStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Event Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.opcoSig)) {
            StructureDataType struct = this.createOpcodeStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Opcode Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.taskSig)) {
            StructureDataType struct = this.createTaskStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Task Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else if (Arrays.equals(sigBytes, this.ttblSig)) {
            StructureDataType struct = this.createTemplateTableStructure(memBuffer, tempOffset);
            newOffset = this.addComp((DataType)struct, struct.getLength(), "Template Table Definition", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else {
            return -1;
        }
        return newOffset;
    }

    private int addComp(DataType dataType, int length, String fieldName, Address address, List<DataTypeComponent> comps, int currentOffset) {
        if (length > 0) {
            ReadOnlyDataTypeComponent readOnlyDataTypeComponent = new ReadOnlyDataTypeComponent(dataType, (DynamicDataType)this, length, comps.size(), currentOffset, fieldName, null);
            comps.add((DataTypeComponent)readOnlyDataTypeComponent);
            currentOffset += length;
        }
        return currentOffset;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<WEVT-Resource>";
    }

    public String getDefaultLabelPrefix() {
        return "WEVT";
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WEVTResourceDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.WEVTResourceDataType", (String)WEVTResourceDataType.class.getName());
    }
}

