/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import docking.DialogComponentProvider;
import docking.DockingErrorDisplay;
import docking.DockingWindowManager;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.framework.SplashScreen;
import docking.widgets.PopupKeyStorePasswordProvider;
import generic.theme.ApplicationThemeManager;
import ghidra.docking.util.LookAndFeelUtils;
import ghidra.formats.gfilesystem.crypto.CryptoProviders;
import ghidra.formats.gfilesystem.crypto.PopupGUIPasswordProvider;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.PluggableServiceRegistry;
import ghidra.framework.main.GhidraApplicationInformationDisplayFactory;
import ghidra.framework.main.UserAgreementDialog;
import ghidra.framework.preferences.Preferences;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.ErrorDisplay;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitorAdapter;

public class GhidraApplicationConfiguration
extends HeadlessGhidraApplicationConfiguration {
    private static final String USER_AGREEMENT_PROPERTY_NAME = "USER_AGREEMENT";
    private boolean showSplashScreen = true;

    public boolean isHeadless() {
        return false;
    }

    @Override
    protected void initializeApplication() {
        ApplicationThemeManager.initialize();
        LookAndFeelUtils.performPlatformSpecificFixups();
        if (this.showSplashScreen) {
            GhidraApplicationConfiguration.showUserAgreement();
            SplashScreen.showLater();
            this.monitor = new StatusReportingTaskMonitor();
        }
        super.initializeApplication();
        ApplicationKeyManagerFactory.setKeyStorePasswordProvider((KeyStorePasswordProvider)new PopupKeyStorePasswordProvider());
        CryptoProviders.getInstance().registerCryptoProvider(new PopupGUIPasswordProvider());
    }

    private static void showUserAgreement() {
        String value = Preferences.getProperty((String)USER_AGREEMENT_PROPERTY_NAME);
        if ("ACCEPT".equals(value)) {
            return;
        }
        SystemUtilities.runSwingNow(() -> {
            UserAgreementDialog dialog = new UserAgreementDialog(true, true);
            DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
        });
        Preferences.setProperty((String)USER_AGREEMENT_PROPERTY_NAME, (String)"ACCEPT");
    }

    public void installStaticFactories() {
        super.installStaticFactories();
        PluggableServiceRegistry.registerPluggableService(ApplicationInformationDisplayFactory.class, (Object)((Object)new GhidraApplicationInformationDisplayFactory()));
    }

    public void setShowSplashScreen(boolean b) {
        this.showSplashScreen = b;
    }

    public ErrorDisplay getErrorDisplay() {
        return new DockingErrorDisplay();
    }

    private static class StatusReportingTaskMonitor
    extends TaskMonitorAdapter {
        private StatusReportingTaskMonitor() {
        }

        public synchronized void setCancelEnabled(boolean enable) {
        }

        public void setMessage(String message) {
            SplashScreen.updateSplashScreenStatus((String)message);
        }
    }
}

