/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyGeneratedPrototype;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAssemblyStateGenerator<N extends AssemblyParseTreeNode> {
    protected static final DbgTimer DBG = AbstractAssemblyTreeResolver.DBG;
    protected final AbstractAssemblyTreeResolver<?> resolver;
    protected final N node;
    protected final AssemblyResolvedPatterns fromLeft;

    public AbstractAssemblyStateGenerator(AbstractAssemblyTreeResolver<?> resolver, N node, AssemblyResolvedPatterns fromLeft) {
        this.resolver = resolver;
        this.node = node;
        this.fromLeft = fromLeft;
    }

    public abstract Stream<AssemblyGeneratedPrototype> generate(GeneratorContext var1);

    protected static class GeneratorContext {
        public final List<AssemblyConstructorSemantic> path;
        public final int shift;

        public static String pathToString(List<AssemblyConstructorSemantic> path) {
            return "[" + path.stream().map(sem -> sem.getLocation()).collect(Collectors.joining(",")) + "]";
        }

        public GeneratorContext(List<AssemblyConstructorSemantic> path, int shift) {
            this.path = List.copyOf(path);
            this.shift = shift;
        }

        public GeneratorContext push(AssemblyConstructorSemantic cons, int shift) {
            ArrayList<AssemblyConstructorSemantic> path = new ArrayList<AssemblyConstructorSemantic>(this.path);
            path.add(cons);
            return new GeneratorContext(path, this.shift + shift);
        }

        public void dbg(String string) {
            DBG.println(GeneratorContext.pathToString(this.path) + ":" + string);
        }
    }
}

