/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyGeneratedPrototype;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseHiddenNode;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AssemblyHiddenConstructStateGenerator
extends AssemblyConstructStateGenerator {
    protected final SubtableSymbol subtableSym;

    public AssemblyHiddenConstructStateGenerator(AbstractAssemblyTreeResolver<?> resolver, SubtableSymbol subtableSym, AssemblyResolvedPatterns fromLeft) {
        super(resolver, null, fromLeft);
        this.subtableSym = subtableSym;
    }

    @Override
    public Stream<AssemblyGeneratedPrototype> generate(AbstractAssemblyStateGenerator.GeneratorContext gc) {
        return IntStream.range(0, this.subtableSym.getNumConstructors()).mapToObj(this.subtableSym::getConstructor).map(this.resolver.grammar::getSemantic).flatMap(sem -> this.applyConstructor(gc, (AssemblyConstructorSemantic)sem));
    }

    protected AssemblyParseTreeNode getFiller() {
        return new AssemblyParseHiddenNode(this.resolver.grammar);
    }

    @Override
    protected List<AssemblyParseTreeNode> orderOpNodes(AssemblyConstructorSemantic sem) {
        Constructor cons = sem.getConstructor();
        AssemblyParseTreeNode hidden = this.getFiller();
        return IntStream.range(0, cons.getNumOperands()).mapToObj(i -> hidden).collect(Collectors.toList());
    }
}

