/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.InvalidInputException;

public class ParameterImpl
extends VariableImpl
implements Parameter {
    protected int ordinal;

    public ParameterImpl(Parameter param, Program program) throws InvalidInputException {
        this(param.getName(), param.getOrdinal(), param.getDataType(), param.getVariableStorage().clone(program), null, null, null, false, program, param.getSource());
    }

    public ParameterImpl(String name, DataType dataType, Program program) throws InvalidInputException {
        this(name, -2, dataType, null, null, null, null, false, program, null);
    }

    public ParameterImpl(String name, DataType dataType, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, -2, dataType, null, null, null, null, false, program, sourceType);
    }

    public ParameterImpl(String name, DataType dataType, int stackOffset, Program program) throws InvalidInputException {
        this(name, -2, dataType, null, null, stackOffset, null, false, program, null);
    }

    public ParameterImpl(String name, DataType dataType, int stackOffset, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, -2, dataType, null, null, stackOffset, null, false, program, sourceType);
    }

    public ParameterImpl(String name, DataType dataType, Register register, Program program) throws InvalidInputException {
        this(name, -2, dataType, null, null, null, register, false, program, null);
    }

    public ParameterImpl(String name, DataType dataType, Register register, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, -2, dataType, null, null, null, register, false, program, sourceType);
    }

    public ParameterImpl(String name, DataType dataType, Address storageAddr, Program program) throws InvalidInputException {
        this(name, -2, dataType, null, storageAddr, null, null, false, program, null);
    }

    public ParameterImpl(String name, DataType dataType, Address storageAddr, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, -2, dataType, null, storageAddr, null, null, false, program, sourceType);
    }

    public ParameterImpl(String name, DataType dataType, VariableStorage storage, Program program) throws InvalidInputException {
        this(name, -2, dataType, storage, null, null, null, false, program, null);
    }

    public ParameterImpl(String name, DataType dataType, VariableStorage storage, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, -2, dataType, storage, null, null, null, false, program, sourceType);
    }

    public ParameterImpl(String name, int ordinal, DataType dataType, VariableStorage storage, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, ordinal, dataType, storage, null, null, null, force, program, sourceType);
    }

    ParameterImpl(String name, int ordinal, DataType dataType, VariableStorage storage, Address storageAddr, Integer stackOffset, Register register, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        super(name, dataType, storage, storageAddr, stackOffset, register, force, program, sourceType);
        this.ordinal = ordinal;
    }

    @Override
    protected final boolean hasDefaultName() {
        return SymbolUtilities.isDefaultParameterName(this.getName());
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final int getFirstUseOffset() {
        return 0;
    }

    @Override
    public DataType getDataType() {
        DataType dt = this.getFormalDataType();
        VariableStorage varStorage = this.getVariableStorage();
        if (varStorage.isForcedIndirect()) {
            Program program = this.getProgram();
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            int ptrSize = varStorage.size();
            dt = ptrSize != dtm.getDataOrganization().getPointerSize() ? dtm.getPointer(dt, ptrSize) : dtm.getPointer(dt);
        }
        return dt;
    }

    @Override
    public DataType getFormalDataType() {
        return super.getDataType();
    }

    @Override
    public boolean isForcedIndirect() {
        VariableStorage varStorage = this.getVariableStorage();
        return varStorage != null ? varStorage.isForcedIndirect() : false;
    }

    @Override
    public boolean isAutoParameter() {
        VariableStorage varStorage = this.getVariableStorage();
        return varStorage != null ? varStorage.isAutoStorage() : false;
    }

    @Override
    public AutoParameterType getAutoParameterType() {
        VariableStorage varStorage = this.getVariableStorage();
        return varStorage != null ? varStorage.getAutoParameterType() : null;
    }
}

