/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.apache.lucene.document.SortedNumericDocValuesSetQuery;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.Query;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();
    private static final FieldType INDEXED_TYPE;

    public static SortedNumericDocValuesField indexedField(String name, long value) {
        return new SortedNumericDocValuesField(name, value, INDEXED_TYPE);
    }

    public SortedNumericDocValuesField(String name, long value) {
        this(name, value, TYPE);
    }

    private SortedNumericDocValuesField(String name, Long value, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue);
    }

    public static Query newSlowSetQuery(String field, long ... values) {
        return new SortedNumericDocValuesSetQuery(field, (long[])values.clone());
    }

    public static Query newSlowExactQuery(String field, long value) {
        return SortedNumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
        INDEXED_TYPE = new FieldType(TYPE);
        INDEXED_TYPE.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
        INDEXED_TYPE.freeze();
    }
}

