/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XTruncate;
import com.sun.star.script.framework.io.XOutputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UCBStreamHandler
extends URLStreamHandler {
    public static final String separator = "/ucb/";
    private final XSimpleFileAccess m_xSimpleFileAccess;
    private final HashMap<String, InputStream> m_jarStreamMap = new HashMap(12);
    private static String m_ucbscheme;

    public UCBStreamHandler(String string, XSimpleFileAccess xSimpleFileAccess) {
        LogUtils.DEBUG("UCBStreamHandler ctor, scheme = " + string);
        m_ucbscheme = string;
        this.m_xSimpleFileAccess = xSimpleFileAccess;
    }

    @Override
    public void parseURL(URL uRL, String string, int n, int n2) {
        LogUtils.DEBUG("**XUCBStreamHandler, parseURL: " + uRL + " spec: " + string + " start: " + n + " limit: " + n2);
        String string2 = uRL.getFile();
        string2 = string2 == null ? string.substring(n, n2) : string2 + string.substring(n, n2);
        LogUtils.DEBUG("**For scheme = " + m_ucbscheme);
        LogUtils.DEBUG("**Setting path = " + string2);
        this.setURL(uRL, m_ucbscheme, null, -1, null, null, string2, null, null);
    }

    @Override
    public URLConnection openConnection(URL uRL) throws IOException {
        return new UCBConnection(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUCBStream(String string, String string2) throws IOException {
        InputStream inputStream;
        block13: {
            InputStream inputStream2 = null;
            inputStream = null;
            try {
                if (string2.endsWith(".jar")) {
                    inputStream2 = this.m_jarStreamMap.get(string2);
                    if (inputStream2 == null) {
                        inputStream2 = this.getFileStreamFromUCB(string2);
                        this.m_jarStreamMap.put(string2, inputStream2);
                    } else {
                        try {
                            inputStream2.reset();
                        }
                        catch (IOException iOException) {
                            inputStream2.close();
                            inputStream2 = this.getFileStreamFromUCB(string2);
                            this.m_jarStreamMap.put(string2, inputStream2);
                        }
                    }
                    inputStream = this.getFileStreamFromJarStream(string, inputStream2);
                    break block13;
                }
                String string3 = PathUtils.make_url(string2, string);
                inputStream = this.getFileStreamFromUCB(string3);
            }
            finally {
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                        LogUtils.DEBUG("Caught exception closing stream: " + iOException.getMessage());
                    }
                }
            }
        }
        return inputStream;
    }

    private InputStream getFileStreamFromJarStream(String string, InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (zipInputStream.available() != 0) {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null || !zipEntry.getName().equals(string)) continue;
            return zipInputStream;
        }
        return null;
    }

    private InputStream getFileStreamFromUCB(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        XInputStream xInputStream = null;
        try {
            LogUtils.DEBUG("Trying to read from " + string);
            xInputStream = this.m_xSimpleFileAccess.openFileRead(string);
            LogUtils.DEBUG("sfa appeared to read file ");
            byte[][] byArrayArray = new byte[1][];
            int n = this.m_xSimpleFileAccess.getSize(string);
            if (n == 0 && xInputStream.available() > 0) {
                n = xInputStream.available();
            }
            LogUtils.DEBUG("size of file " + string + " is " + n);
            LogUtils.DEBUG("available = " + xInputStream.available());
            byArrayArray[0] = new byte[n];
            int n2 = xInputStream.readBytes((byte[][])byArrayArray, n);
            if (n2 != n) {
                throw new IOException("Failed to read " + n + " bytes from XInputStream");
            }
            byteArrayInputStream = new ByteArrayInputStream(byArrayArray[0]);
        }
        catch (com.sun.star.io.IOException iOException) {
            IOException iOException2 = new IOException();
            iOException2.initCause(iOException);
            throw iOException2;
        }
        catch (com.sun.star.uno.Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        finally {
            if (xInputStream != null) {
                try {
                    xInputStream.closeInput();
                }
                catch (Exception exception) {
                    LogUtils.DEBUG("Error closing XInputStream: " + exception.getMessage());
                }
            }
        }
        return byteArrayInputStream;
    }

    private class UCBConnection
    extends URLConnection {
        public UCBConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler GetInputStream on " + this.url);
            String string = this.url.toString();
            if (string.lastIndexOf(UCBStreamHandler.separator) == -1) {
                LogUtils.DEBUG("getInputStream straight file load");
                return UCBStreamHandler.this.getFileStreamFromUCB(string);
            }
            String string2 = string.substring(0, string.lastIndexOf(UCBStreamHandler.separator));
            String string3 = string.substring(string.lastIndexOf(UCBStreamHandler.separator) + UCBStreamHandler.separator.length());
            LogUtils.DEBUG("getInputStream, load of file from another file eg. " + string3 + " from " + string2);
            return UCBStreamHandler.this.getUCBStream(string3, string2);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            LogUtils.DEBUG("UCBConnectionHandler getOutputStream on " + this.url);
            XOutputStreamWrapper xOutputStreamWrapper = null;
            try {
                String string = this.url.toString();
                if (string.lastIndexOf(UCBStreamHandler.separator) != -1) {
                    String string2 = string.substring(0, string.lastIndexOf(UCBStreamHandler.separator));
                    if (UCBStreamHandler.this.m_xSimpleFileAccess.isReadOnly(string2)) {
                        throw new IOException("File is read only");
                    }
                    LogUtils.DEBUG("getOutputStream, create o/p  stream  for file eg. " + string2);
                    XOutputStream xOutputStream = UCBStreamHandler.this.m_xSimpleFileAccess.openFileWrite(string2);
                    XTruncate xTruncate = (XTruncate)UnoRuntime.queryInterface(XTruncate.class, (Object)xOutputStream);
                    if (xTruncate != null) {
                        xTruncate.truncate();
                    }
                    xOutputStreamWrapper = new XOutputStreamWrapper(xOutputStream);
                }
                if (xOutputStreamWrapper == null) {
                    throw new IOException("Failed to get OutputStream for " + string);
                }
            }
            catch (CommandAbortedException commandAbortedException) {
                LogUtils.DEBUG("caught exception: " + commandAbortedException.toString() + " getting writable stream from " + this.url);
                IOException iOException = new IOException(commandAbortedException.getMessage());
                iOException.initCause(commandAbortedException);
                throw iOException;
            }
            catch (com.sun.star.uno.Exception exception) {
                LogUtils.DEBUG("caught unknown exception: " + exception.toString() + " getting writable stream from " + this.url);
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
            return xOutputStreamWrapper;
        }
    }
}

