/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.constant.ADCommonMessages;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.DeleteAnomalyResultsAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.resources.ResourceSharingClientAccessor;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.PluginClient;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteAnomalyResultsTransportAction
extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse> {
    private final Client client;
    private final PluginClient pluginClient;
    private volatile Boolean filterEnabled;
    private final boolean shouldUseResourceAuthz;
    private static final Logger logger = LogManager.getLogger(DeleteAnomalyResultsTransportAction.class);

    @Inject
    public DeleteAnomalyResultsTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, ClusterService clusterService, Client client, PluginClient pluginClient) {
        super(DeleteAnomalyResultsAction.NAME, transportService, actionFilters, DeleteByQueryRequest::new);
        this.client = client;
        this.pluginClient = pluginClient;
        this.shouldUseResourceAuthz = ParseUtils.shouldUseResourceAuthz("anomaly-detector");
        this.filterEnabled = (Boolean)AnomalyDetectorSettings.AD_FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_FILTER_BY_BACKEND_ROLES, it -> {
            this.filterEnabled = it;
        });
    }

    protected void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> actionListener) {
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, ADCommonMessages.FAIL_TO_DELETE_AD_RESULT);
        this.delete(request, (ActionListener<BulkByScrollResponse>)listener);
    }

    public void delete(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.validateRole(request, user, listener);
        }
        catch (Exception e) {
            logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void validateRole(DeleteByQueryRequest request, User user, ActionListener<BulkByScrollResponse> listener) {
        if (user == null || !this.filterEnabled.booleanValue() && !this.shouldUseResourceAuthz) {
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
        } else {
            try {
                if (this.shouldUseResourceAuthz) {
                    this.addAccessibleConfigsFilterAndDelete(request.getSearchRequest(), listener);
                    return;
                }
                if (this.filterEnabled.booleanValue()) {
                    ParseUtils.addUserBackendRolesFilter(user, request.getSearchRequest().source());
                }
                this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    private void addAccessibleConfigsFilterAndDelete(SearchRequest request, ActionListener<BulkByScrollResponse> listener) {
        logger.debug("Filtering result by accessible resources");
        ResourceSharingClient resourceSharingClient = ResourceSharingClientAccessor.getInstance().getResourceSharingClient();
        SearchSourceBuilder searchSourceBuilder = request.source();
        resourceSharingClient.getAccessibleResourceIds("anomaly-detector", ActionListener.wrap(configIds -> {
            searchSourceBuilder.query(DeleteAnomalyResultsTransportAction.mergeWithAccessFilter(searchSourceBuilder.query(), configIds));
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
        }, failure -> {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchAllQuery()));
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
        }));
    }

    public static QueryBuilder mergeWithAccessFilter(QueryBuilder existing, Set<String> configIds) {
        BoolQueryBuilder accessFilter;
        Object object = accessFilter = configIds == null || configIds.isEmpty() ? QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchAllQuery()) : QueryBuilders.termsQuery((String)"detector_id", configIds);
        if (existing == null) {
            return QueryBuilders.boolQuery().filter((QueryBuilder)accessFilter);
        }
        if (existing instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)existing).filter((QueryBuilder)accessFilter);
            return existing;
        }
        return QueryBuilders.boolQuery().must(existing).filter((QueryBuilder)accessFilter);
    }
}

