/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.Version;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.indexmanagement.util.OpenForTesting;

@OpenForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "value", "", "flag", "getFlag", "()Z", "hasLegacyPlugin", "getHasLegacyPlugin", "sweepISMPluginVersion", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "opensearch-index-management"})
public class SkipExecution {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private volatile boolean flag;
    private volatile boolean hasLegacyPlugin;

    public final boolean getFlag() {
        return this.flag;
    }

    public final boolean getHasLegacyPlugin() {
        return this.hasLegacyPlugin;
    }

    public void sweepISMPluginVersion(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        try {
            Version currentMinVersion = clusterService.state().getNodes().getMinNodeVersion();
            Version currentMaxVersion = clusterService.state().getNodes().getMaxNodeVersion();
            if (currentMinVersion != null && !currentMinVersion.equals((Object)currentMaxVersion)) {
                this.flag = true;
                this.logger.info("There are multiple versions of Index Management plugins in the cluster: [" + currentMaxVersion + ", " + currentMinVersion + "]");
            } else {
                this.flag = false;
            }
            if (currentMinVersion.major > Version.CURRENT.major && !Intrinsics.areEqual((Object)currentMinVersion, (Object)currentMaxVersion)) {
                this.hasLegacyPlugin = true;
                this.logger.info("Found legacy plugin versions [" + currentMinVersion + "] and opensearch plugins versions [" + currentMaxVersion + "] in the cluster");
            } else {
                this.hasLegacyPlugin = false;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to fetch node versions from cluster service", (Throwable)e);
        }
    }
}

