/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.BadParametersException;
import com.password4j.Utils;
import java.util.Arrays;

class Blake2b {
    private static final long[] IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] SIGMA = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};
    private static final int ROUNDS = 12;
    private static final int BLOCK_LENGTH_BYTES = 128;
    private final int digestLength;
    private final int keyLength;
    private final byte[] buffer;
    private final long[] internalState = new long[16];
    private int bufferPos = 0;
    private long[] chainValue = null;
    private long t0 = 0L;
    private long t1 = 0L;
    private long f0 = 0L;

    Blake2b(int digestSize) {
        if (digestSize < 1 || digestSize > 64) {
            throw new BadParametersException("BLAKE2b digest bytes length must be not greater than 64");
        }
        this.buffer = new byte[128];
        this.keyLength = 0;
        this.digestLength = digestSize;
        this.init();
    }

    private void init() {
        this.chainValue = new long[8];
        this.chainValue[0] = IV[0] ^ ((long)this.digestLength | (long)this.keyLength << 8 | 0x1010000L);
        this.chainValue[1] = IV[1];
        this.chainValue[2] = IV[2];
        this.chainValue[3] = IV[3];
        this.chainValue[4] = IV[4];
        this.chainValue[5] = IV[5];
        this.chainValue[6] = IV[6];
        this.chainValue[7] = IV[7];
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ IV[4];
        this.internalState[13] = this.t1 ^ IV[5];
        this.internalState[14] = this.f0 ^ IV[6];
        this.internalState[15] = IV[7];
    }

    void update(byte[] message) {
        if (message == null) {
            return;
        }
        this.update(message, 0, message.length);
    }

    void update(byte[] message, int offset, int len) {
        int messagePos;
        int remainingLength = 0;
        if (this.bufferPos != 0) {
            remainingLength = 128 - this.bufferPos;
            if (remainingLength < len) {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, remainingLength);
                this.t0 += 128L;
                if (this.t0 == 0L) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, len);
                this.bufferPos += len;
                return;
            }
        }
        int blockWiseLastPos = offset + len - 128;
        for (messagePos = offset + remainingLength; messagePos < blockWiseLastPos; messagePos += 128) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
            this.compress(message, messagePos);
        }
        System.arraycopy(message, messagePos, this.buffer, 0, offset + len - messagePos);
        this.bufferPos += offset + len - messagePos;
    }

    void doFinal(byte[] out, int outOffset) {
        this.f0 = -1L;
        this.t0 += (long)this.bufferPos;
        if (this.bufferPos > 0 && this.t0 == 0L) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0L);
        for (int i = 0; i < this.chainValue.length && i * 8 < this.digestLength; ++i) {
            byte[] bytes = Utils.longToLittleEndian(this.chainValue[i]);
            if (i * 8 < this.digestLength - 8) {
                System.arraycopy(bytes, 0, out, outOffset + i * 8, 8);
                continue;
            }
            System.arraycopy(bytes, 0, out, outOffset + i * 8, this.digestLength - i * 8);
        }
        Arrays.fill(this.chainValue, 0L);
        this.reset();
    }

    void reset() {
        this.bufferPos = 0;
        this.f0 = 0L;
        this.t0 = 0L;
        this.t1 = 0L;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        this.init();
    }

    private void compress(byte[] message, int messagePos) {
        this.initializeInternalState();
        long[] m = new long[16];
        for (int j = 0; j < 16; ++j) {
            m[j] = Utils.littleEndianToLong(message, messagePos + j * 8);
        }
        for (int round = 0; round < 12; ++round) {
            this.functionG(m[SIGMA[round][0]], m[SIGMA[round][1]], 0, 4, 8, 12);
            this.functionG(m[SIGMA[round][2]], m[SIGMA[round][3]], 1, 5, 9, 13);
            this.functionG(m[SIGMA[round][4]], m[SIGMA[round][5]], 2, 6, 10, 14);
            this.functionG(m[SIGMA[round][6]], m[SIGMA[round][7]], 3, 7, 11, 15);
            this.functionG(m[SIGMA[round][8]], m[SIGMA[round][9]], 0, 5, 10, 15);
            this.functionG(m[SIGMA[round][10]], m[SIGMA[round][11]], 1, 6, 11, 12);
            this.functionG(m[SIGMA[round][12]], m[SIGMA[round][13]], 2, 7, 8, 13);
            this.functionG(m[SIGMA[round][14]], m[SIGMA[round][15]], 3, 4, 9, 14);
        }
        for (int offset = 0; offset < this.chainValue.length; ++offset) {
            this.chainValue[offset] = this.chainValue[offset] ^ this.internalState[offset] ^ this.internalState[offset + 8];
        }
    }

    private void functionG(long m1, long m2, int posA, int posB, int posC, int posD) {
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m1;
        this.internalState[posD] = Long.rotateRight(this.internalState[posD] ^ this.internalState[posA], 32);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Long.rotateRight(this.internalState[posB] ^ this.internalState[posC], 24);
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m2;
        this.internalState[posD] = Long.rotateRight(this.internalState[posD] ^ this.internalState[posA], 16);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Long.rotateRight(this.internalState[posB] ^ this.internalState[posC], 63);
    }
}

