/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.DialogAddUser;
import org.zaproxy.zap.extension.users.DialogModifyUser;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextUsersPanel
extends AbstractContextPropertiesPanel {
    private UsersMultipleOptionsPanel usersOptionsPanel;
    private ContextUserAuthManager contextManager;
    private ExtensionUserManagement extension;
    private UsersTableModel usersTableModel;
    private static final long serialVersionUID = -3920598166129639573L;
    private static final String PANEL_NAME = Constant.messages.getString("users.panel.title");

    public ContextUsersPanel(ExtensionUserManagement extension, int contextId) {
        super(contextId);
        this.contextManager = extension.getContextUserAuthManager(contextId);
        this.extension = extension;
        this.initialize();
    }

    public static String getPanelName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextUsersPanel.getPanelName(this.getContextId()));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Constant.messages.getString("users.panel.description")), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
        this.usersTableModel = new UsersTableModel();
        this.usersOptionsPanel = new UsersMultipleOptionsPanel(this.extension, this.usersTableModel, this.getContextId());
        this.add((Component)this.usersOptionsPanel, LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiCommonContext) {
        this.usersOptionsPanel.setWorkingContext(uiCommonContext);
        this.usersTableModel.setUsers(this.contextManager.getUsers());
    }

    @Override
    public void validateContextData(Session session) throws Exception {
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.contextManager.setUsers(this.usersTableModel.getUsers());
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
    }

    protected UsersTableModel getUsersTableModel() {
        return this.usersTableModel;
    }

    public static class UsersMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<User> {
        private static final long serialVersionUID = -7216673905642941770L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("users.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("users.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("users.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("users.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("users.dialog.remove.checkbox.label");
        private DialogAddUser addDialog = null;
        private DialogModifyUser modifyDialog = null;
        private ExtensionUserManagement extension;
        private Context uiSharedContext;

        public UsersMultipleOptionsPanel(ExtensionUserManagement extension, UsersTableModel model, int contextId) {
            super(model);
            this.extension = extension;
            this.getTable().getColumnExt(0).setPreferredWidth(40);
            this.getTable().getColumnExt(1).setPreferredWidth(30);
            this.getTable().getColumnExt(1).setMaxWidth(50);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public User showAddDialogue() {
            boolean valid = this.uiSharedContext.getAuthenticationMethod().validateCreationOfAuthenticationCredentials();
            if (!valid) {
                return null;
            }
            if (this.addDialog == null) {
                this.addDialog = new DialogAddUser((Dialog)View.getSingleton().getSessionDialog(), this.extension);
                this.addDialog.pack();
            }
            this.addDialog.setWorkingContext(this.uiSharedContext);
            this.addDialog.setVisible(true);
            User user = this.addDialog.getUser();
            this.addDialog.clear();
            return user;
        }

        @Override
        public User showModifyDialogue(User user) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyUser((Dialog)View.getSingleton().getSessionDialog(), this.extension);
                this.modifyDialog.pack();
            }
            this.modifyDialog.setWorkingContext(this.uiSharedContext);
            this.modifyDialog.setUser(user);
            this.modifyDialog.setVisible(true);
            user = this.modifyDialog.getUser();
            this.modifyDialog.clear();
            return user;
        }

        @Override
        public boolean showRemoveDialogue(User e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getSessionDialog(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }

        protected void setWorkingContext(Context context) {
            this.uiSharedContext = context;
        }
    }
}

